# -*- coding: UTF-8 -*-

import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Information About Snapshots
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    
    cliRet = getCliRet(dataDict, "showsnapshot")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."          
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 4:
            continue
        """P12V-2728, 20130509 Begin"""
        if list2[3] in ("Rollback") or bool(re.search("Fault", list2[3], re.IGNORECASE)):
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n虚拟快照" + list2[0] + u"的状态（" + list2[3] + u"）存在异常。" 
            else:
                errMsg += "\nThe status(" + list2[3] + ") of Snapshot " + \
                list2[0] + " is abnormal."
        """P12V-2728, 20130509 End"""

    return (flag, cliRet, errMsg)