# -*- coding: UTF-8 -*-
import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger
from common.sysInfoManager import isDoubleCtrlsModel

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Write Cache Utility
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    flag = CheckedResult.PASS
    errMsg = ""
    lang = getLang(dataDict) 
    writeCacheUtil = "Write Cache Utility"
    
    cliRet = getCliRet(dataDict, "showcache")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."    
        return (flag, cliRet, errMsg)
    
    #Dorado5100 SPC001没有该字段，通过
    if writeCacheUtil not in cliRet:
        return (flag, cliRet, errMsg)
    
    #获取所有控制器Cache写利用率
    writeCacheUtiDict = {}
    controllerId = ""
    writeCacheUti = ""
    highWaterLevel = ""
    lowWaterLevel = ""
    avgWaterLevel = 0

    for field in list:
        list2 = field.split("|")
        if len(list2) == 2:
            if re.search("Controller ID", field, re.IGNORECASE):
                controllerId = list2[1].strip()
            elif re.search("High Water Level", field, re.IGNORECASE):
                highWaterLevel = list2[1].strip()
            elif re.search("Low Water Level", field, re.IGNORECASE):
                lowWaterLevel = list2[1].strip()
            elif re.search("Write Cache Utility", field, re.IGNORECASE):
                writeCacheUti = list2[1].strip()
                if controllerId != "":
                    writeCacheUtiDict[controllerId] = writeCacheUti
                    #初始化变量
                    controllerId = ""
                    writeCacheUti = ""
        else:
            continue

    #获取信息失败
    if highWaterLevel == "" or lowWaterLevel == "" or len(writeCacheUtiDict) != 2:
        flag = CheckedResult.NOTPASS
        if lang == "zh":
            errMsg = u"\n获取Cache信息失败。"
        else:
            errMsg = "\nGetting Cache data failed."          
        return (flag, cliRet, errMsg)
    
    #查看写利用率是否大于高水位与低水位的平均值
    try:
        for key in writeCacheUtiDict:
            #获取高低水位平均值
            avgWaterLevel = (int(highWaterLevel) + int(lowWaterLevel))/2
            #当前写利用率高于平均值，检查不通过
            if  int(writeCacheUtiDict[key]) > avgWaterLevel:
                flag = CheckedResult.NOTPASS
                if lang == "zh":
                    errMsg += u"\n控制器" + key + u"的Cache写利用率过高（" + unicode(writeCacheUtiDict[key]) + u"）。"
                else:
                    errMsg += "\nThe Write Cache Utility of controller " + key + " is too high (" + unicode(writeCacheUtiDict[key]) + ")."
    except:
        flag = CheckedResult.NOTPASS
        if lang == "zh":
            errMsg = u"Cli信息异常。"
        else:
            errMsg = "\nThe cli information is abnormal."        
    
    #检查结果返回
    return (flag, cliRet, errMsg)
