# -*- coding: UTF-8 -*-
from frame.context import contextUtil
from frame.common import common
from frame.common import exportFileUtil
from frame.cli import cliUtil
import commonHandler
import xmlParser
import Error
import os
import traceback
from com.huawei.ism.exception import IsmException

errLevel = [False, cliUtil.RESULT_WARNING, cliUtil.RESULT_NOCHECK, True]


def execute(context, queryCheckItem): 
    '''
    @summary: 解析器的主流程控制函数
    @param queryCheckItem: 检查项id，和规则文件中的id对应
    @return : 
        flag:queryCheckItem检查项结果
        cliRet:原始信息
        errMsg:错误提示消息
    ''' 
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    
    try:
        xmlInfo = contextUtil.getItem(context, "xmlInfo")
        if xmlInfo == None:
            #获取xml文件解析后的字典
            xmlInfo = xmlParser.parseRuleXmlFile(logger)
            contextUtil.setItem(context, "xmlInfo", xmlInfo)
            
            #获取xml中所有data的属性值，构成一个属性list
            allDataXmlList = xmlParser.getAllDataXml(xmlInfo, logger)
            
            #所有<data>结点，构造key为"type"、"title"的嵌套字典
            dataAttrDict = xmlParser.constrXmlDataAttrDict(allDataXmlList, logger)
            contextUtil.setItem(context, "dataAttrDict", dataAttrDict)
        
        dataAttrDict = contextUtil.getItem(context, "dataAttrDict")
        
        #在运行数据文件中提取出的所有数据表的字典
        localConfigFile =  os.path.join(contextUtil.getCollectTmpDir(context), common.TMP_FILE_NAME)
        allTableStrDict = contextUtil.getItem(context, "allTableStrDict")
        if allTableStrDict == None:
            allTableStrDict = commonHandler.getAllTableStrDict(xmlInfo, dataAttrDict, localConfigFile, logger)  
            contextUtil.setItem(context, "allTableStrDict", allTableStrDict)
            
        #根据传入的检查项id取到这个节点中所有的rule形成的list
        rulesXmlList = xmlParser.getCheckitemRulesList(queryCheckItem, xmlInfo)
        if len(rulesXmlList) == 0:
            errMsg = common.getMsg(lang,"queryitem.not.in.xml")
            return (cliUtil.RESULT_NOCHECK, "", errMsg)
        
        #获取datasets里的数据集字典
        datasetsDict = contextUtil.getItem(context, "datasetsDict")
        if datasetsDict == None:
            datasetsXml = xmlParser.getChildNodeXml(xmlInfo, "datasets")
            datasetsDict = commonHandler.getDatasetsDict(datasetsXml, localConfigFile, logger)
            contextUtil.setItem(context, "datasetsDict", datasetsDict)
        
        #某个检查项里的所有rule的校验，得到检查项结果
        matchRet = getRulesMatchRet(rulesXmlList, allTableStrDict, dataAttrDict, datasetsDict, logger, lang)
        return matchRet
    
    except Exception, ex: 
        (flag, errMsg) = handleAnalyzeException(ex, logger, lang)
        if not flag:
            raise
        return (cliUtil.RESULT_NOCHECK, "", errMsg)


def getTableStrByName(context, name):
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    try:

        configCollectRiskItem = contextUtil.getItem(context, "configCollectRisk")
        if not configCollectRiskItem:
            flag, cliRet, errMsg = checkCollectConfigRisk(context)
            contextUtil.setItem(context, "configCollectRisk", (flag, cliRet, errMsg))
        else:
            flag = configCollectRiskItem[0]
            cliRet = configCollectRiskItem[1]
            errMsg = configCollectRiskItem[2]

        if not flag:
            logger.logInfo("cannot exportconfig file.")
            return (False, errMsg)

        exportRet = exportConfigFile(context)
        if exportRet[0] != True:
            return False, ""

        xmlInfo = contextUtil.getItem(context, "xmlInfo")
        if xmlInfo == None:
            # 获取xml文件解析后的字典
            xmlInfo = xmlParser.parseRuleXmlFile(logger)
            contextUtil.setItem(context, "xmlInfo", xmlInfo)

            # 获取xml中所有data的属性值，构成一个属性list
            allDataXmlList = xmlParser.getAllDataXml(xmlInfo, logger)

            # 所有<data>结点，构造key为"type"、"title"的嵌套字典
            dataAttrDict = xmlParser.constrXmlDataAttrDict(allDataXmlList, logger)
            contextUtil.setItem(context, "dataAttrDict", dataAttrDict)

        dataAttrDict = contextUtil.getItem(context, "dataAttrDict")

        # 在运行数据文件中提取出的所有数据表的字典
        localConfigFile = os.path.join(contextUtil.getCollectTmpDir(context), common.TMP_FILE_NAME)
        allTableStrDict = contextUtil.getItem(context, "allTableStrDict")
        if allTableStrDict == None:
            allTableStrDict = commonHandler.getAllTableStrDict(xmlInfo, dataAttrDict, localConfigFile, logger)
            contextUtil.setItem(context, "allTableStrDict", allTableStrDict)
        return True, allTableStrDict[name]
    except:
        return False, ""

def getRulesMatchRet(rulesXmlList, allTableStrDict, dataAttrDict, datasetsDict, logger, lang):    
    '''
    @summary: 某个检查项里的所有rule的校验，返回所有rule结果的并集
    @param rulesXmlList:某个检查项中所有rule节点的xml信息
    @return: 
        isSuccess:queryCheckItem检查项结果
        cliRet:config取得的原始数据
        errMsg:错误提示消息
    '''
    errMsg = ""   
    checkRet  =""
    convertDataDict = {}
    flag = True
    
    titleAttrDict = dataAttrDict.get("title")
    
    #遍历所有规则，判断是否符合条件
    for node in rulesXmlList:
        nodeAttrDict = node["elementAttrbutes"]
        #判断用到的数据表，转换表数据为list
        name = nodeAttrDict["index"].split('.')[0]
      
        if convertDataDict.has_key(name) == False:  
            currentTableStr = allTableStrDict[name]
            checkRet += currentTableStr
            convertRet = commonHandler.converTableToList(currentTableStr, dataAttrDict, name, logger, lang)
            
            if convertRet[0] != True:
                errMsg +=  convertRet[2]
                flag = getErrLevel(flag, convertRet[0])
            convertDataDict.setdefault(name, convertRet[1])  
                
        if  convertDataDict.has_key(name) and len(convertDataDict.get(name)) == 0:
            continue
        
        #该检查项需要的所有数据都在 convertDataDict中 
        matchRet = commonHandler.ruleMatch(nodeAttrDict, convertDataDict, titleAttrDict, datasetsDict, logger, lang)
        if matchRet[0] != True:
            flag = getErrLevel(flag, matchRet[0])
            errMsg += matchRet[1]

    return (flag, checkRet, errMsg)   



def getErrLevel(flag, newFlag):
    '''
    @summary:通过配置返回值级别的高低，返回结果
    '''
    for level in errLevel:
        if flag == level or newFlag ==level:
            return level
    return False

def handleAnalyzeException(exception, logger, lang):
    '''
    @summary: 处理解析器异常时，返回失败的结果给上下文对象
    @param exception: 异常信息
    '''
    errMsg = ""
    expArgs = exception.args
    if expArgs is not None and len(expArgs) == 2:
        errCode = str(expArgs[0]).strip()
        
        keys = Error.ERROR_CODE_DEFINE.keys()
        if errCode in keys:
            errInfo = contextUtil.ERROR_CODE_DEFINE.get(errCode, {})
            errMsg = errInfo.get("errMsg_%s" % lang, "")
            suggestion = errInfo.get("suggestion_%s" % lang, "")
            return (True, ''.join((errMsg, suggestion)) )
    else:
        logger.logException(exception)
    return (False, "")


def executeAnalyzer(context, queryCheckItem):
    '''
    @summary: 执行使用解析器的检查项的通用方法
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    originalRet = ""
    
    try:
        configCollectRiskItem = contextUtil.getItem(context, "configCollectRisk")
        if not configCollectRiskItem:
            flag, cliRet, errMsg = checkCollectConfigRisk(context)
            contextUtil.setItem(context, "configCollectRisk", (flag, cliRet, errMsg))
        else:
            flag = configCollectRiskItem[0]
            cliRet = configCollectRiskItem[1]
            errMsg = configCollectRiskItem[2]

        if not flag:
            logger.logInfo("cannot exportconfig file.")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
        exportRet = exportConfigFile(context)
        originalRet += exportRet[1]
        if exportRet[0] != True:
            return (exportRet[0],  originalRet,  exportRet[2])

        #执行解析器
        (flag, cliRet, errMsg) = execute(context, queryCheckItem)
        originalRet += cliRet
        
        return (flag, originalRet, errMsg)
    
    except Exception as exception:
        logger.logException(exception)
        return (False, originalRet, common.getMsg(lang, "analyze.query.result.abnormal"))


def checkCollectConfigRisk(context):
    '''
    @summary: 工具规避在收集日志时触发的问题
    retrun：False：表示是风险版本
            True：表示不是风险版本
    '''

    # 系统版本及热补丁风险版本
    riskVersionDict = {
        'V300R006C20': 'V300R006C20SPH015',
        'V500R007C10': 'V500R007C10SPH015',
        'V300R006C20SPC100': 'V300R006C20SPH115',
        'V500R007C10SPC100': 'V500R007C10SPH115',
        'V300R006C50SPC100': 'V300R006C50SPH105',
        'V500R007C30SPC100': 'V500R007C30SPH105',
        'V300R001C21SPC100': 'V300R001C21SPH112',
        'V300R002C10SPC100': 'V300R002C10SPH101',
        'V300R001C30SPC100': 'V300R001C30SPH106'
    }
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    lang = contextUtil.getLang(context)
    cli = contextUtil.getSSH(context)
    allCliRet = ""
    try:

        flag, currentSoftVersion, currentHotpatchVersion = cliUtil.getSystemVersion(cli, lang)
        allCliRet += "product version: %s, hotpath version: %s" % (currentSoftVersion, currentHotpatchVersion)
        if flag != True:
            raise Exception

        # 对版本型号及热补丁版本进行适配,如果系统版本不涉及则通过
        if currentSoftVersion not in riskVersionDict:
            return True, allCliRet, ""

        needInstallHotpatchVersion = riskVersionDict.get(currentSoftVersion)
        # 如果热补丁版本匹配则通过
        if currentHotpatchVersion != '--' and currentHotpatchVersion >= needInstallHotpatchVersion:
            return True, allCliRet, ""

        # 如果热补丁版本不匹配
        # 需判断启动器数量和控制器冗余
        cmd = "show initiator initiator_type=FC"
        flag, cliRet, _ = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        allCliRet += "\n" + cliRet
        if flag != True:
            raise Exception
        iniDictList = cliUtil.getHorizontalCliRet(cliRet)
        normalInitiatorCount = 0
        for iniDict in iniDictList:
            if iniDict.get("Running Status", '').lower() == "online":
                normalInitiatorCount += 1

        isAllCtrlNormal = True
        cmd = "show controller general"
        flag, cliRet, _ = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        allCliRet += "\n" + cliRet
        if flag != True:
            raise Exception
        controllerDictList = cliUtil.getVerticalCliRet(cliRet)
        for controllerDict in controllerDictList:
            if controllerDict.get("Health Status", '').lower() != "normal":
                isAllCtrlNormal = False
                break

            if controllerDict.get("Running Status", '').lower() != "online":
                isAllCtrlNormal = False
                break

        logger.logInfo("hot patch version is lower than request, normal fc Initiator Count:%s, isAllCtrlNormal:%s" % (
                      normalInitiatorCount, isAllCtrlNormal))

        if normalInitiatorCount <= 200 and isAllCtrlNormal:
            return True, allCliRet, ""

        # 未安装对应补丁，且启动器数量超过200个或控制器不正常，限制收集。
        return False, allCliRet, common.getMsg(lang, "install.fc.driver.risk.patch", needInstallHotpatchVersion)
    except:
        logger.logInfo("checkCollectConfigRisk exception[%s]" % traceback.format_exc())
        return False, allCliRet, common.getMsg(lang, "analyze.query.result.abnormal")



def exportConfigFile(context):
    '''
    @summary: 导出config文件
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getCLI(context)
    sftp = contextUtil.getSFTP(context)  
    exportRet = (True, "", "")
    
    exportFlag = contextUtil.getItem(context, "exportFlag")
    logger.logInfo("exportFlag: [%s]" % exportFlag)
    if exportFlag == True:
        return exportRet
    
    exportType = common.EXPORT_TYPE_RUNNING_DATA
    localConfigDir = contextUtil.getCollectTmpDir(context)
    logger.logInfo("current download dir: [%s]" % localConfigDir)
    #创建临时文件夹
    if not os.path.exists(localConfigDir):
        os.makedirs(localConfigDir)
    localConfigFile =  os.path.join(localConfigDir, common.TMP_FILE_NAME)
    
    cycle_times = 3
    for i in range(0,cycle_times):
        logger.logInfo("export running data for %s times." % (i+1))
        exportRet = exportFileUtil.downloadStorageFile(lang, cli, sftp, logger, exportType, localConfigFile)
        if exportRet[0] == True:             
            contextUtil.setItem(context, "exportFlag", True)

            return (exportRet[0], exportRet[1]+"\n\n", exportRet[2])
        if common.isRemoteExistFile(exportRet[1]):
            deleteRet = common.deleteCollectFile(cli, lang, common.EXPORT_TYPE_RUNNING_DATA)
            logger.logInfo("delete collect file result: %s" % unicode(deleteRet))
    
    return exportRet

