# -*- coding: UTF-8 -*-
from defusedxml import ElementTree as ET
import os


def parseRuleXmlFile(logger):
    '''
    @summary: 获取xml文件解析后的字典
    @param logger: 日志打印对象
    @return: xml解析的字典
    '''
    xmlInfo = {}
    try:
        ruleXmlFile =  getRuleXmlFile()
       
        xmlInfo = parseXMLFile(ruleXmlFile)
        return xmlInfo
        
    except Exception, ex:
        logger.logException(ex)
        raise Exception("ERROR00001", ex)
    

def parseXMLFile(filePath):
    '''
    @summary: 解析xml文件
    @param filePath: xml文件路径
    @return: 解析后的xml文件信息（一个嵌套的字典)
    '''
    xmlElementTree = ET.parse(filePath)
    rootElement = xmlElementTree.getroot()
    #通过解析xml文件的根节点来解析整个文件
    xmlInfo = parseXMLElement(rootElement)
    return xmlInfo

  
def parseXMLElement(element):
    '''
    @summary: 递归调用解析xml节点
    @param element: xml的一个节点
    @return: 解析后的xml节点信息（一个嵌套的字典)
    '''
    elementName = element.tag
    elementAttrbutes = element.attrib
    if element.text == None:
        element.text = ""
    elementText = element.text.strip()
    
    #对节点的子节点
    elementChildEles = []
    childElements = element.getchildren()
    for childElement in childElements:
        elementChildEles.append(parseXMLElement(childElement))
    
    #将xml节点的名称，属，文本，子节点存放到字典
    elementInfo = {    
                   "elementName":elementName,
                   "elementAttrbutes":elementAttrbutes,
                   "elementText":str(elementText),
                   "elementChildEles":elementChildEles       
                   }  
    
    return elementInfo


def parseHostCompatibilityXml(SECTORS):
    '''
    @summary: 根据XML的文件路径，解析XML
    @param configFile: XML文件路径
    @return: 
        listInfo: 返回字典类型的列表信息
    '''
    curDir = os.path.dirname(__file__)
    xmlFile = os.path.join(curDir, "baseconnectivity_blacklist.xml")

    listInfo = []
    try:
        root = ET.parse(xmlFile)
        records = root.getiterator("RECORD")
        for record in records:
            items = record.getchildren()
            tempDict = {}

            for item in items:
                if item.tag in SECTORS:
                    tempDict[item.tag] = item.text if item.text else ""
            listInfo.append(tempDict)
        return True, listInfo
    except:
        return False, []




def getCheckitemRulesList(queryCheckItem, xmlInfo):
    '''
    @summary: 获取ID为queryId的检查项(checkItem)节点
    @param:
        queryCheckItem: 检查项查询id
        xmlInfo:xml规则文件解析的字典集
    '''
    
    rulesXmlList = []
    
    checkItemsXmlList = getChildNodeXml(xmlInfo, "checkItems")
    #查找id为queryCheckItem的检查项节点
    for node in checkItemsXmlList:
        if queryCheckItem == node["elementAttrbutes"]["id"]:
            rulesXmlList = node["elementChildEles"]
            break
        
    return rulesXmlList


def getChildNodeXml(xmlInfo, nodeType):
    '''
    @summary: 取xmlInfo字典中，节点类型为nodeType中的所有子节点(datas/checkItems/datasets)
    '''
    reList = []
    childXmlInfo = xmlInfo["elementChildEles"]
    for node in childXmlInfo:
        if nodeType == node["elementName"]:
            reList = node["elementChildEles"]
            break
    return reList


def getAllDataXml(xmlInfo, logger):
    '''
    @summary: 获取所有data的属性值，即每项data，构成一个属性list
    '''
    datasXmlInfo = getChildNodeXml(xmlInfo, "datas")
    
    allDataXmlList = [dataNode["elementAttrbutes"] for dataNode in datasXmlInfo]
    logger.logInfo("##allDataXmlList##: %s" % str(allDataXmlList))
    
    return allDataXmlList
    
      
def constrXmlDataAttrDict(allDataXmlList, logger):
    '''
    @summary: 构造key为"type"、"title"的嵌套字典，方便根据传入的name获取某个<data>节点title或者type
    '''
    dataAttrDict = {}
    dataAttrDict.setdefault("title", {})
    dataAttrDict.setdefault("type", {})
    
    for dataList in allDataXmlList:
        dataAttrDict["title"].setdefault(dataList["name"],dataList["title"])
        dataAttrDict["type"].setdefault(dataList["name"],dataList["type"])
    
    logger.logInfo("##dataAttrDict##: %s" % str(dataAttrDict))    
    
    return dataAttrDict


   
def getRuleXmlFile():
    '''
    @summary: 获取版本号获取不同的rule.xml文件
    '''
    curDir = os.path.dirname(__file__)
    fileName = "rule.xml"
    
    return os.path.join(curDir, fileName)    
    
    

