# -*- coding: UTF-8 -*-

from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

#FW版本在特定范围内的MODEL值对照字典
BLACK_RANGE_MODEL_FW = {
                        'HSSD-D3J2JAM5400':('8701','9105'),
                        'HSSD-D3J2JAM5600':('8701','9105'),
                        'HSSD-D3J2LAM5400':('8701','9105'),
                        'HSSD-D3J2LAM5600':('8701','9105')
                        }

DISK_ID = "ID"
DISK_MODEL = "Model"
DISK_FW_VER = "Firmware Version"

def execute(context):
    '''
    @summary:  hssd固件版本检测 
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""
    
    DiskIDList = []#检测到不通过硬盘的ID信息
    errInfoDiskList = []#获取Model和FW失败的硬盘

    cmd = "show disk general |filterColumn include columnList=ID,Manufacturer,Model,Firmware\sVersion"
    logger.logExecCmd(cmd)
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, False, lang)
    if checkRet[0] != True: 
        logger.logSysAbnormal()
        return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
    
    cliRet = checkRet[1]
    printCliRet(cliRet,20,logger)
    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    if len(cliRetLinesList) == 0:
        return common.getUpgEvaluationRs(True, cliRet, errMsg)
       
    for cliRetLine in cliRetLinesList:
        diskID = cliRetLine.get(DISK_ID,"")
        model = cliRetLine.get(DISK_MODEL,"")
        FWVersion = cliRetLine.get(DISK_FW_VER,"")
        if model == "" or model == "--" or FWVersion == "" or FWVersion == "--":
            errInfoDiskList.append(diskID)
            continue
        if isDiskInSpecRange(model,FWVersion):
            DiskIDList.append(diskID)
                
    if DiskIDList:
        flag = cliUtil.RESULT_WARNING
        #对硬盘列表排序
        DiskIDList.sort()
        idStr = ", ".join(DiskIDList)
        errMsg += common.getMsg(lang, "disk.fw.ver.early", idStr)
    
    if errInfoDiskList:
        flag = False
        #对硬盘列表排序
        errInfoDiskList.sort()
        idStr = ", ".join(errInfoDiskList)
        errMsg += common.getMsg(lang, "cannot.get.disk.fw.model.failed", idStr)
    return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    
def isDiskInSpecRange(Model,fwVersion):
    blackFWRange = BLACK_RANGE_MODEL_FW.get(Model,None)
    if not blackFWRange:
        return False
    if fwVersion>=blackFWRange[0] and fwVersion <= blackFWRange[1]:
        return True
    return False

def printCliRet(cliRet, num, logger):
    '''
    @summary: 以num作为规格划分打印日志
    '''
    lines = cliRet.splitlines()
    length = len(lines)
    for i in range(1, length):
        mul = i%num
        if mul == 0:
            logger.logInfo("\n%s" % "\n".join(lines[i-num:i]))
            continue
        if i == length-1:
            logger.logInfo("\n%s" % "\n".join(lines[i-mul:length]))
    return
