# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
         引擎状态检查：
                 所有控制器均在线，Health Status为Normal且Running Status为Online表示正常，其它情况均属于不正常状态。
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show controller general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.controller.info")
            LOGGER.logNoPass("Cannot get information about controller")
            return common.getUpgEvaluationRs(False, cliRet, errMsg)
        
        engineList = []
        engineSlotDict = {}
        for retDict in cliRetLinesList:
            ctrlId = retDict["Controller"]
            healthStatus = retDict["Health Status"]
            runningStatus = retDict["Running Status"]
            
            engineId = ctrlId[0]
            slot = ctrlId[1]
            engineList.append(engineId)
            
            if engineSlotDict.has_key(engineId):
                slots = engineSlotDict.get(engineId).append(slot)
                engineSlotDict.setdefault(engineId, slots)
            else:
                engineSlotDict.setdefault(engineId, [slot])
                
            if healthStatus != common.STATUS_NORMAL and runningStatus == common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "controller.health.status.abnormal", (ctrlId, healthStatus))
                LOGGER.logNoPass("The Health Status of Controller [%s] is abnormal (Health Status:%s)"  % (ctrlId, healthStatus))
            elif healthStatus == common.STATUS_NORMAL and runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "controller.running.status.abnormal", (ctrlId, runningStatus))
                LOGGER.logNoPass("The Running Status of Controller [%s] is abnormal (Running Status:%s)" % (ctrlId, runningStatus))
            elif healthStatus != common.STATUS_NORMAL and runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "controller.status.abnormal", (ctrlId, healthStatus, runningStatus))
                LOGGER.logNoPass("The Status of controller [%s] is abnormal (Health Status:%s,Running Status:%s)" % 
                    (ctrlId, healthStatus, runningStatus))
            else:
                continue
        
        isSiglePdtModel = common.isSigleModel(cli, LANG)
        if not isSiglePdtModel:
            for engine in set(engineList):
                slots = engineSlotDict.get(engine)
                controllerId = ", ".join([(engine + slot) for slot in slots])
                if slots not in (["A", "B"], ["A", "B", "C", "D"]):
                    flag = False
                    errMsg += common.getMsg(LANG, "engine.may.be.offline", engine)
                    LOGGER.logNoPass("The controller in the engine [%s] may be offline (%s)" % (engine, controllerId))
                
        if flag:
            LOGGER.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
