# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
        机框状态检查：
                机框Health Status为Normal且Running Status为Online为正常，其它情况均属于不正常状态。
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show enclosure"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.enclosure.info")
            LOGGER.logNoPass("Cannot get information about enclosure")
            return common.getUpgEvaluationRs(False, cliRet, errMsg)

        for line in cliRetLinesList:
            enclosureId = line["ID"]
            healthStatus = line["Health Status"]
            runningStatus = line["Running Status"]
            
            if healthStatus != common.STATUS_NORMAL and runningStatus == common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "enclosure.health.status.abnormal", (enclosureId, healthStatus))
                LOGGER.logNoPass("The Health Status of enclosure [%s] is abnormal (Health Status:%s)" % 
                    (enclosureId, healthStatus))
            elif healthStatus == common.STATUS_NORMAL and runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "enclosure.running.status.abnormal", (enclosureId, runningStatus))
                LOGGER.logNoPass("The Running Status of enclosure [%s] is abnormal (Running Status:%s)" % 
                    (enclosureId, runningStatus))
            elif healthStatus != common.STATUS_NORMAL and runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "enclosure.status.abnormal", (enclosureId, healthStatus, runningStatus))
                LOGGER.logNoPass("The Status of enclosure [%s] is abnormal (Health Status:%s,Running Status:%s)" % 
                    (enclosureId, healthStatus, runningStatus))
            else:
                continue
        if flag:
            LOGGER.logPass()

        return common.getUpgEvaluationRs(flag, cliRet, errMsg)

    except Exception, exception: 
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
