# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
        风扇状态检查: 
                所有风扇均在位，Health Status为Normal且Running Status为Running表示正常，其它情况均属于不正常状态。
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    cliRetAll = ""
    errMsg = ""

    try:
        cmd = "show enclosure"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        cliRetAll = checkRet[1]
        
        
        cmd = "show enclosure|filterColumn include columnList=ID,Height(U)"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        enclosureList = []
        enclosureInfoDict = {}
        
        for line in cliRetLinesList:
            enclosureId = line["ID"]
            if cliUtil.isEngineId(enclosureId) or cliUtil.isDiskId(enclosureId) or cliUtil.isDataSwitchId(enclosureId):
                enclosureList.append(enclosureId)
                enclosureInfoDict[enclosureId] = line
                
        if len(enclosureList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.enclosure.info")
            LOGGER.logNoPass("Cannot get information about enclosure")
            return common.getUpgEvaluationRs(False, cliRetAll, errMsg)
        
        checkRet = cliUtil.getControllerIdList(cli, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        controllerIdList = checkRet[1]
        
        checkRet = cliUtil.getHighDensityDiskEnclosureIdList(cli, LANG)
        if checkRet[0] != True:  
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        highDensityDiskEnclosureIdList = checkRet[1]
        
        cmd = "show fan"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRetAll += checkRet[1]
        if checkRet[0] != True:
            errMsg += checkRet[2]
            LOGGER.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], cliRetAll, errMsg)
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.fan.info")
            LOGGER.logNoPass("Cannot get information about fan")
            return common.getUpgEvaluationRs(False, cliRetAll, errMsg)
        
        enclosureIdDict = {}
        for enclosure in enclosureList:
            enclosureIdDict[enclosure] = 0
            
        for line in cliRetLinesList:
            fanID = line["ID"]
            enclosureId = fanID.split(".")[0]
            healthStatus = line["Health Status"]
            runningStatus = line["Running Status"]
            
            if enclosureIdDict.has_key(enclosureId):
                enclosureIdDict[enclosureId] += 1
            
            if healthStatus != common.STATUS_NORMAL and runningStatus == common.STATUS_RUNNING:
                flag = False
                errMsg += common.getMsg(LANG, "fan.health.status.abnormal", (fanID, healthStatus))
                LOGGER.logNoPass("The Health Status of fan [%s] is abnormal (Health Status:%s)" % 
                    (fanID, healthStatus))
            elif healthStatus == common.STATUS_NORMAL and runningStatus != common.STATUS_RUNNING:
                flag = False
                errMsg += common.getMsg(LANG, "fan.running.status.abnormal", (fanID, runningStatus))
                LOGGER.logNoPass("The Running Status of fan [%s] is abnormal (Running Status:%s)" % 
                    (fanID, runningStatus))
            elif healthStatus != common.STATUS_NORMAL and runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "fan.status.abnormal", (fanID, healthStatus, runningStatus))
                LOGGER.logNoPass("The Status of fan [%s] is abnormal (Health Status:%s,Running Status:%s)" % 
                    (fanID, healthStatus, runningStatus))
            else:
                continue
        
        for enclosure in enclosureList:
            enclosureInfo = enclosureInfoDict.get(enclosure)
            standFanConfigRet = common.getEnclosureFanConfig(cli, enclosureInfo, controllerIdList, highDensityDiskEnclosureIdList, LANG)
            
            if standFanConfigRet[0] != True:
                errMsg += standFanConfigRet[2]
                cliRetAll += standFanConfigRet[1]
                LOGGER.logNoPass("Cannot get standard fans configuration")
                return common.getUpgEvaluationRs(standFanConfigRet[0], cliRetAll, errMsg)
            
            standFanNum = standFanConfigRet[1]
            currentFanNum = enclosureIdDict.get(enclosure)
            if currentFanNum < standFanNum:
                flag = False
                errMsg += common.getMsg(LANG, "fan.number.not.enough", (enclosure, standFanNum, currentFanNum))
                LOGGER.logNoPass("The number of fan in enclosure [%s] is not enough (Required Number:%s, Current Number:%s)" 
                     % (enclosure, standFanNum, currentFanNum))
        
        if flag:
            LOGGER.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRetAll, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
