# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
        Online upgrade IOPS check
        Only the product version V300R002C10 of 5600 V3 dual control is not passed.Otherwise,the check is passed. 
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    cliRet = ""
    errMsg = ""
    
    DEV_TYPE_BLACK_LIST = ["5600 V3"]
    DEV_VER_BLACK_LIST = ["V300R002C10"]
    
    try:
        try:
            cmd = "show system general"
            result = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
            cliRet = result[1]
            
            cmd = "show controller general"
            result = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
            cliRet = cliRet + '\n' + result[1]
        except Exception, exception: 
            logger.logException(exception)
        
        devVersion = contextUtil.getCurVersion(context)
        logger.logInfo("[check_cli_hardware_onlineUpgradeCausingIOPSDecline]device version is %s" %devVersion)
        if devVersion not in DEV_VER_BLACK_LIST:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, errMsg) 
        
        devType = contextUtil.getDevType(context)
        logger.logInfo("[check_cli_hardware_onlineUpgradeCausingIOPSDecline]device type is %s" %devType)
        if devType not in DEV_TYPE_BLACK_LIST:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, errMsg) 
        
        getCtrlIdsRes = cliUtil.getControllerIdList(cli, lang)
        logger.logInfo("[check_cli_hardware_onlineUpgradeCausingIOPSDecline]get controllers result: %s" %unicode(getCtrlIdsRes))
        if not getCtrlIdsRes[0]:
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(getCtrlIdsRes[0], getCtrlIdsRes[1], getCtrlIdsRes[2])
         
        if len(getCtrlIdsRes[1]) != 2:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, errMsg) 
        
        errMsg = common.getMsg(lang, "check.iops.abnormal")
        return common.getUpgEvaluationRs(False, cliRet, errMsg)
        
    except Exception, exception:     
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
