# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
    LUN迁移运行状态检查：
        1 如果LUN迁移不存在表示正常；
        2 Running Status为Fault表示不正常，否则表示正常。
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show lun_migration general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return common.getUpgEvaluationRs(checkRet[0], cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.lun.migration.info")
            LOGGER.logNoPass("Cannot get information about LUN migration")
            return common.getUpgEvaluationRs(False, cliRet, errMsg)

        for line in cliRetLinesList:
            Id = line["Source LUN ID"]
            runningStatus = line["Running Status"]
            if runningStatus == common.STATUS_FAULT:
                flag = False
                errMsg += common.getMsg(LANG, "lun.migration.running.status.abnormal", (Id, runningStatus))
                LOGGER.logNoPass("The Running Status of LUN migration%s] is abnormal (Running Status:%s)" 
                     % (Id, runningStatus))

        if flag:
            LOGGER.logPass()
                 
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(LANG, "query.result.abnormal"))

