# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from java.lang import Exception as JException

def execute(context):
    '''
    @summary: cache分区不镜像LUN检查
    '''
    
    cliRet = ""
    try:
        lang = contextUtil.getLang(context)
        logger = common.getLogger(contextUtil.getLogger(context), __file__)
        cli = contextUtil.getSSH(context)
        cmd = "show lun_cache no_mirror_lun"
        flag, cliRet, errMsg = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang, preExec=False)
        if flag != True:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, errMsg)

        cliRet2List = cliUtil.getVerticalCliRet(cliRet)
        if len(cliRet2List) == 0:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))

        hasNoMirrorLun = cliRet2List[0].get("Has_No_Mirror_Lun", "")
        if hasNoMirrorLun.lower() == "no":
            return common.getUpgEvaluationRs(True, cliRet, "")
        return common.getUpgEvaluationRs(False, cliRet, "")

    except (Exception, JException), exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))
    

    
