# -*- coding: UTF-8 -*-
import ast
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

from frame.rest.restUtil import RestService
from frame.rest.restData import EnumStr

def execute(context):
    '''
    检查复制子系统各对象状态是否允许升级：
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    cliRet = ""
    errMsg = ""
    
    try:
        cmd = "show rsf upgrade_check_info"
        logger.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang)

        # 命令不存在场景时，返回不涉及
        if not cliUtil.hasCliExecPrivilege(checkRet[1]):
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, checkRet[1], "")

        rest = contextUtil.getRest(context)
        recordErrDict = {}
        errInfoDict = {}
        uri ="rsf_upgrade_check_info"
        rsfRecords = RestService.getForRange(rest, uri)
        for rsfRecord in rsfRecords:
            errorCode = rsfRecord.get("errorCode")
            checkedObjType = rsfRecord.get("checkedObjType")
            checkedObjId = rsfRecord.get("checkedObjId")
            errorString = rsfRecord.get("errorString")

            errInfoDict[errorCode] = ast.literal_eval(errorString)

            objDict =  recordErrDict.get(errorCode, None)
            if objDict == None:
                objDict = {checkedObjType:[checkedObjId]}
                recordErrDict[errorCode] = objDict
            else:
                objIdList = objDict.get(checkedObjType, None)
                if objIdList == None:
                    objIdList = [checkedObjId]
                else:
                    objIdList.append(checkedObjId)

        if len(errInfoDict) == 0:
            logger.logInfo("The rsf upgrde check result is pass")
            return common.getUpgEvaluationRs(True, rsfRecords, errMsg)

        for key,value in errInfoDict.items():
            objStr = ""
            objDict = recordErrDict.get(key)
            for objType,objIdList in objDict.items():
                objTypeName = common.getEnumMsg(lang, EnumStr.StrRsfObjTypeEnum, int(objType))
                objStr += objTypeName + "(ID=%s)," %",".join(objIdList)
            objStr = objStr[:-1]#去掉最后一个逗号
            errMsg += common.getMsg(lang, "rsf.upgrade.notpass.info",
                                    (unicode(value.get("description")), key,
                                     unicode(value.get("suggestion")), objStr))

        logger.logNoPass("The rsf upgrde check result is no pass")

        return common.getUpgEvaluationRs(False, rsfRecords, errMsg)
    
    except Exception, exception:     
        logger.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))


