# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.rest.restUtil import RestService
from com.huawei.ism.exception import IsmException
import traceback

OM_CMD_FAILOVER_CODE = {1073793298: "RETURN_SYSTEM_NOT_SUPPORT_SINGLE_MODE",
                        1073813270: "RETURN_FAILOVER_SWITCH_DISABLED",
                        1077949112: "RETURN_SYSTEM_NOT_SUPPORT",
                        1073813268: "RETURN_FAILOVER_ONLY_SUPPORT_DEFAULT_UPD_BATCH",
                        1073743400: "RETURN_FCOE_SERVICE_EXIST_IN_SYSTEM"}

OM_CMD_FAILOVER_ERRORCODE = [1073813263, 1073813264, 1073813265, 1073813266, 1073813267]

OLD_VER_V3 = 'V300R006C10SPC100'
OLD_VER_V5 = 'V500R007C00SPC100'
OLD_VER_DORADO = 'V300R001C21SPC100'
NEW_VER_V3 = 'V300R006C20'
NEW_VER_V5 = 'V500R007C10'
NEW_VER_DORADO = 'V300R001C30'

def execute(context):
    '''
        端口漂移组网检查：
        1、如果端口漂移命令不存在时，结果为不涉及；
        2、如果端口漂移命令存在且端口漂移开关为关闭时，结果为通过；
        3、如果端口漂移命令存在且端口漂移开关打开时且端口漂移组网检测结果返回正常时，结果为通过；
        4、如果检测过程中出现网络等异常时，结果为未检查；
        5、其他情况时，结果为不通过
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)

    cliRetAll = ""

    try:
        #记录检测端口漂移
        devNode = contextUtil.getDevObj(context)
        devNode.setFailover(True)
        #检测端口漂移命令是否存在
        cmd = "show upgrade port_failover_switch"
        if isOldDevVer(context):
            cmd = "show logical_port failover_switch service_type=SAN"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG, preExec=False)
        cliRet = checkRet[1]
        #命令不存在场景时，返回不涉及
        if not cliUtil.hasCliExecPrivilege(cliRet):
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, checkRet[2])

        if checkRet[0] != True:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, checkRet[2])

        cliRetAll += cliRet

        return failOverRestRet(contextUtil, LOGGER, LANG, cliRetAll, cli, context)
    except Exception, exception:
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))


def failOverRestRet(contextUtil, LOGGER, LANG, cliRetAll, cli, context):
    try:
        rest = contextUtil.getRest(context)
        uri = "check_front_end_net"
        flag = True
        paramDict = dict(serviceType="0", scene="0")
        restRet = RestService.put(rest, uri, paramDict)
        return common.getUpgEvaluationRs(flag, cliRetAll, "")
    except (IsmException, Exception), msg:
        LOGGER.logInfo("exception=[%s]" % str(traceback.format_exc()))
        LOGGER.logInfo("exception msg=%s" % msg)
        # 如果命令字不存在，检查直接通过。
        if int(msg.getErrorId()) in OM_CMD_FAILOVER_CODE.keys():
            errMsg = common.getMsg(LANG, OM_CMD_FAILOVER_CODE[int(msg.getErrorId())])
            return common.getUpgEvaluationRs(False, cliRetAll, errMsg)
        if int(msg.getErrorId()) in OM_CMD_FAILOVER_ERRORCODE:
            try:
                errMsg, cliRetAll = failedReasonResult(cli, LANG, LOGGER, cliRetAll)
                return common.getUpgEvaluationRs(False, cliRetAll, errMsg)
            except:
                LOGGER.logInfo("exception=[%s]" % str(traceback.format_exc()))
                return common.getUpgEvaluationRs(False, cliRetAll, common.getMsg(LANG, "check.failover.notpass"))
        if int(msg.getErrorId()) == -1:
            ok, cliRet, errMsg = failOverCliRet(cli, LANG, cliRetAll, LOGGER)
            return common.getUpgEvaluationRs(ok, cliRet, errMsg)
        return common.getUpgEvaluationRs(False, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))

def failOverCliRet(cli, LANG, cliRetAll, LOGGER):
    try:
        # 组网检测
        cmd = "test logical_port failover service_type=SAN"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG, preExec=False)
        cliRet = checkRet[1]
        cliRetAll += cliRet

        if cliUtil.queryResultWithNoRecord(cliRet):
            return True, cliRetAll, ""
                
        # 命令不存在场景时，返回不涉及
        if not cliUtil.hasCliExecPrivilege(cliRet):
            return cliUtil.RESULT_NOSUPPORT, cliRetAll, checkRet[2]

        return False, cliRetAll, common.getMsg(LANG, "check.failover.notpass")
    except Exception, msg:
        LOGGER.logInfo("exception=[%s]" % str(traceback.format_exc()))
        LOGGER.logInfo("exception msg=%s" % msg)
        return cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(LANG, "query.result.abnormal")

def failedReasonResult(cli, LANG, LOGGER, cliRetAll):
    cmd = "show failover_path general"
    (ok, cliRet, errorMsg) = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
    LOGGER.logExecCmd(cmd)
    if ok != True:
        return common.getMsg(LANG, "check.failover.notpass"), cliRetAll
    suggessionList = []
    allSuggession = common.getMsg(LANG, "cli_software_checkFailover.common")
    cliRetAll += cliRet
    cliRetList = cliUtil.getHorizontalCliRet(cliRet)
    trueResult = ["True", "NA"]
    for oneRet in cliRetList:
        if oneRet.get("Available") == "True":
            continue
        LOGGER.logInfo(oneRet)
        suggession = ''
        if oneRet.get("Target Port") == "--":
            suggession += "\n" + common.getMsg(LANG, "cli_software_checkFailover.0.notpass")
            suggessionList.append('\n' + str(len(suggessionList)+1) + ') ' + common.getMsg(LANG, "cli_software_checkFailover.common.1", (oneRet.get("Source Port"), oneRet.get("Target Port")))
                                  + suggession)
            continue

        sourcePortNPIVResult = oneRet.get("Source Port NPIV")
        if sourcePortNPIVResult == "False":
            suggession += "\n" + common.getMsg(LANG, "cli_software_checkFailover.1.notpass")
        elif sourcePortNPIVResult == "--":
            suggession += "\n" + common.getMsg(LANG, "cli_software_checkFailover.1.notcheck")

        sourceSwitchNPIVResult = oneRet.get("Source Switch NPIV")
        if sourceSwitchNPIVResult == "False":
            suggession += "\n" + common.getMsg(LANG, "cli_software_checkFailover.2.notpass")
        elif sourceSwitchNPIVResult == "--":
            suggession += "\n" + common.getMsg(LANG, "cli_software_checkFailover.2.notcheck")

        targetPortNPIVResult = oneRet.get("Target Port NPIV")
        if targetPortNPIVResult == "False":
            suggession += "\n" + common.getMsg(LANG, "cli_software_checkFailover.3.notpass")
        elif targetPortNPIVResult == "--":
            suggession += "\n" + common.getMsg(LANG, "cli_software_checkFailover.3.notcheck")

        targetSwitchNPIVResult = oneRet.get("Target Switch NPIV")
        if targetSwitchNPIVResult == "False":
            suggession += "\n" + common.getMsg(LANG, "cli_software_checkFailover.4.notpass")
        elif targetSwitchNPIVResult == "--":
            suggession += "\n" + common.getMsg(LANG, "cli_software_checkFailover.4.notcheck")

        if oneRet.get("Free Link Enough") not in trueResult:
            suggession += "\n" + common.getMsg(LANG, "cli_software_checkFailover.5.notpass")

        if oneRet.get("Redundancy") != "True":
            suggession += "\n" + common.getMsg(LANG, "cli_software_checkFailover.6.notpass")

        if oneRet.get("Failover Status") == "Taking over":
            suggession += "\n" + (common.getMsg(LANG, "cli_software_checkFailover.7.notpass"))

        if oneRet.get("Failover Status") == "Failed-over":
            suggession += "\n" + (common.getMsg(LANG, "cli_software_checkFailover.8.notpass"))

        if suggession:
            LOGGER.logInfo(suggession)
            suggessionList.append('\n' + str(len(suggessionList)+1) + ') ' + common.getMsg(LANG, "cli_software_checkFailover.common.1", (oneRet.get("Source Port"), oneRet.get("Target Port"))) 
                                  + suggession)
   
    if suggessionList:
        return allSuggession + ''.join(suggessionList), cliRetAll

    suggession = common.getMsg(LANG, "check.failover.notpass")
    return suggession, cliRetAll

def isOldDevVer(dataDict):
    devVer = contextUtil.getCurVersion(dataDict)
    if contextUtil.isDoradoDev(dataDict):
        if devVer <= OLD_VER_DORADO:
            return True
    else:
        if ("V3" in devVer and  devVer <= OLD_VER_V3) or ("V5"in devVer and devVer <= OLD_VER_V5):
            return True
    return False