# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.frame.cli import cliUtil
from frame.common import common

CMD_CHECK = 'show hyper_metro_pair general'

# 仅针对目标版本为以下版本
RELATED_TARGET_VERSION = ['V300R002C00', 'V300R002C00SPC100', 'V300R002C10',
                          'V300R002C10SPC100', 'V300R002C20']


# 双活Pair配置检查
def execute(context):
    cli = contextUtil.getCli(context)
    logger = contextUtil.getLogger(context)
    lang = contextUtil.getLang(context)
    target_version = context.get('dev').getDestVersion()
    recs = ''
    if target_version not in RELATED_TARGET_VERSION:
        return common.getUpgEvaluationRs(True, '', '')
    try:
        flag, recs, err_msg = cliUtil.excuteCmdInCliMode(
            cli, CMD_CHECK, True, lang)
        if flag is not True:
            return common.getUpgEvaluationRs(flag, recs, err_msg)
        no_record_message = 'No matching records'
        if no_record_message in recs:
            return common.getUpgEvaluationRs(True, recs, '')
        return common.getUpgEvaluationRs(
            False, recs, common.getMsg(lang, "hypermetro.pause.check.fail"))
    except Exception as ex:
        logger.error('query hyper_metro_pair config error', ex)
        return common.getUpgEvaluationRs(
            cliUtil.RESULT_NOCHECK, recs,
            common.getMsg(lang, "query.result.abnormal"))
