# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.common.regex import Regex
import time

QUERY_PAL_TIMES = 10 #循环查询次数
INTERVAL_TIME = 3 #查询间隔时间3s

def execute(context):
    '''
    @summary: 文件系统业务状态检查
            型号：所有型号：5300V35500V35600V35800V36800V318500V318800V3
    '''
    includeVer = ["V300R002C00","V300R002C00SPC100","V300R002C10","V300R002C10SPC100","V300R002C10SPC200","V300R003C00","V300R003C00SPC100"]
    includeTargetVer = ["V300R003C00","V300R003C00SPC100","V300R003C10"]
    nonCommandVer = ["V300R002C10"]
    
    cli = contextUtil.getSSH(context)
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    targetVersion = contextUtil.getTargetVersion(context)
    cliRet = ""
    ctrIDList = []
    cliRetToShow = ""
    errMsg = ""
    try:
        #检查是否在版本范围内
        getDevVersionRet = common.getDevVersion(cli, lang, logger)
        cliRetToShow += getDevVersionRet[2]
        if not getDevVersionRet[0]:
            logger.logNoPass("get dev version failed")
            errMsg = common.getMsg(lang,"cannot.get.version")
            return common.getUpgEvaluationRs(False, cliRetToShow, errMsg)
        
        devVersion = getDevVersionRet[1]
        logger.logInfo("the version(%s) and targetVersion(%s)" %(devVersion, targetVersion))
        
        if devVersion not in includeVer or targetVersion not in includeTargetVer:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRetToShow, "")
        
        if devVersion in nonCommandVer:
            logger.logNoPass("this version not support cli command for check io")
            return common.getUpgEvaluationRs(False, cliRetToShow, common.getMsg(lang, "check.iocounter.warning"))
        
        #get all the controller id
        ctrIDListRet = cliUtil.getControllerIdList(cli, lang)
        if not ctrIDListRet[0]:
            logger.logNoPass("get ctrl id failed")
            cliRetToShow += ctrIDListRet[1]
            return common.getUpgEvaluationRs(False, cliRetToShow, ctrIDListRet[2])
        ctrIDList = ctrIDListRet[1]
        logger.logInfo("The ctrl ids are:%s" %(unicode(ctrIDList)))
        # enter developer model
        enterDeveloperRet = cliUtil.enterDeveloperMode(cli, lang)
        cliRetToShow += enterDeveloperRet[1]
        if not enterDeveloperRet[0]:
            logger.logNoPass("enter the developer mode failed")
            return common.getUpgEvaluationRs(False, enterDeveloperRet[1], enterDeveloperRet[2])
        
        #query the io data
        checkResult = checkIOInfo(context, ctrIDList)
        cliRetToShow += checkResult[1]
        if not checkResult[0]:
            return common.getUpgEvaluationRs(False, cliRetToShow, checkResult[2])
        return common.getUpgEvaluationRs(cliUtil.RESULT_WARNING, cliRetToShow, checkResult[2])
         
    except Exception as exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRetToShow, common.getMsg(lang, "query.result.abnormal"))
    finally:
        try:
            if cliUtil.isInDeveloperMode(cliRet):
                cliUtil.developerMode2CliMode(cli)
        except:
            logger.logNoPass("change cli mode failed")

def checkIOInfo(context, ctrIDList):
    #query the io data
    cli = contextUtil.getSSH(context)
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    
    try:
        #只打印IO计数变化的原始信息
        cliRetToShow = ""
        cmd = "show pal counter controller=%s"
        lastTotalStrDict = {}
        queryTimes = 0
        
        while queryTimes < QUERY_PAL_TIMES:
            time.sleep(INTERVAL_TIME)
            for ctrID in ctrIDList:
                checkRet = cliUtil.excuteCmdInCliMode(cli, cmd%ctrID, True, lang)
                
                if not checkRet[0]:
                    cliRetToShow += checkRet[1]
                    logger.logSysAbnormal()
                    return (False, cliRetToShow, checkRet[2])
                cliRet = checkRet[1]
                totalStr = getPalCounterTotal(cliRet,logger)
                lastTotalStr = lastTotalStrDict.get(ctrID,"")
                if lastTotalStr == "":
                    cliRetToShow += checkRet[1]
                    lastTotalStrDict[ctrID] = totalStr
                    continue
                if lastTotalStr == totalStr:
                    continue
                else:
                    cliRetToShow += checkRet[1]
                    logger.logNoPass("Services exist in system,lastIO(%s)!=IO(%s)"%(lastTotalStr,totalStr))
                    return (False, cliRetToShow, common.getMsg(lang,"check.iocounter.exist"))
            queryTimes += 1
        
        return (True, cliRetToShow, common.getMsg(lang, "check.iocounter.warning"))
    except Exception, exception:
        logger.logException(exception)
        return (False, cliRetToShow, common.getMsg(lang, "query.result.abnormal"))
     
def getPalCounterTotal(cliRet,logger):
    totalLine = ""
    cliRetList = cliRet.encode("utf8").splitlines()
    for line in cliRetList:
        if Regex.search("TOTAL", line):
            totalLine = line
            break
    return totalLine