# -*- coding: UTF-8 -*-
from frame.common import common
from frame.context import contextUtil
from cbb.frame.base.config import HOT_PATCH_VERSION_DICT, \
    HOT_PATCH_VERSION_DICT_DORADO, HOT_PATCH_VERSION_DICT_DORADO_NAS
from frame.common.regex import Regex
from frame.base import baseUtil
from cbb.business.operate.checkitems import check_required_hot_patch
from cbb.frame.base.config import REQUIRED_PATCH_LIST

def execute(context):
    '''
    @summary: 特殊路径下是否安装热补丁
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    
    needInstallFlag = True
    cliRet = ""
    errMsg = ""
    try:
        #获取当前版本号
        getDevVersionRet = common.getDevVersion(cli, lang, logger)
        if not getDevVersionRet[0]:
            if lang == "zh":
                errMsg = u"无法获取产品版本信息"
            else:
                errMsg = "Cannot get information about product version"
            return common.getUpgEvaluationRs(getDevVersionRet[0], getDevVersionRet[2], errMsg)
        curVersion = getDevVersionRet[1]
        logger.logInfo('curVersion:%s'%curVersion)
        cliRet = getDevVersionRet[2]
        devType = contextUtil.getDevType(context)

        # 获取补丁版本号
        getHotPatchVersionRet = common.getHotPatchVersion(cli, lang)
        if not getHotPatchVersionRet[0]:
            return common.getUpgEvaluationRs(getHotPatchVersionRet[0],
                                             getHotPatchVersionRet[2],
                                             getHotPatchVersionRet[3])
        hotPatchVersion = getHotPatchVersionRet[1]
        logger.logInfo('hotPatchVersion:%s' % hotPatchVersion)

        # 先用公共的逻辑进行检查
        flag, required_patch, err_msg = \
            check_required_hot_patch.check_patch_version(
                context, curVersion, hotPatchVersion,
                devType, REQUIRED_PATCH_LIST)
        if not flag:
            return common.getUpgEvaluationRs(False, cliRet, err_msg)

        isDoradoDevice = baseUtil.isDoradoDev(devType)
        isDoradoNas = baseUtil.isDoradoNasDev(devType)
        if isDoradoDevice:
            if curVersion not in HOT_PATCH_VERSION_DICT_DORADO.keys():
                return common.getUpgEvaluationRs(True, cliRet, errMsg)
        elif isDoradoNas:
            if curVersion not in HOT_PATCH_VERSION_DICT_DORADO_NAS.keys():
                return common.getUpgEvaluationRs(True, cliRet, errMsg)
        else:
            if curVersion not in HOT_PATCH_VERSION_DICT.keys():
                return common.getUpgEvaluationRs(True, cliRet, errMsg)



        dueHotPatchVersionList = []
        if isDoradoDevice:
            dueHotPatchVersionList = HOT_PATCH_VERSION_DICT_DORADO.get(curVersion)
        elif isDoradoNas:
            dueHotPatchVersionList = HOT_PATCH_VERSION_DICT_DORADO_NAS.get(curVersion)
        else:
            dueHotPatchVersionList = HOT_PATCH_VERSION_DICT.get(curVersion)

        # 判断标准以最后安装补丁为准
        last_patch = dueHotPatchVersionList[-1]
        if last_patch.endswith('#'):
            expect_patch_ver = last_patch[:-1]
            if expect_patch_ver == "" or hotPatchVersion != expect_patch_ver:
                err_msg = common.getMsg(
                    lang, "install.suggestion.for.urgent.patch")
                return common.getUpgEvaluationRs(False, cliRet, err_msg)
            return common.getUpgEvaluationRs(True, cliRet, errMsg)

        if dueHotPatchVersionList[-1].endswith('+'):
            dueHotPatchVersion = dueHotPatchVersionList[-1][:-1]
            if hotPatchVersion >= dueHotPatchVersion:
                needInstallFlag = False
        else:
            if hotPatchVersion == dueHotPatchVersionList[-1]:
                needInstallFlag = False

        logger.logInfo('needInstallFlag:%s'%str(needInstallFlag))
        if not needInstallFlag:
            return common.getUpgEvaluationRs(True, cliRet, errMsg)
        else:
            resourceHotPatchVersionStr = common.getMsg(lang, 'comma.res').join(dueHotPatchVersionList)
            resourceHotPatchVersionStr = resourceHotPatchVersionStr.replace('+', common.getMsg(lang, 'install.patch.hotpatch'))
            resourceHotPatchVersionStr = Regex.replaceAll("B01[2,3]", resourceHotPatchVersionStr, '')


            errMsg = common.getMsg(lang, "install.onlyone.hotpatch", resourceHotPatchVersionStr)
            if len(dueHotPatchVersionList) > 1:
                errMsg = common.getMsg(lang, "install.many.hotpatch", resourceHotPatchVersionStr)
            return common.getUpgEvaluationRs(False, cliRet, errMsg)
            
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
