# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from cbb.business.checkitems.pool_balance_task_check \
    import PoolBalanceTaskCheck
from cbb.frame.checkitem.context_adapter import UpgradeEvalContext
from frame.context import contextUtil
from business.common import common

ITEM_ID = "cli_software_pool_balancetask"
CHECK_BALANCE_TASK_TIMES = 120


def execute(context):
    """
    检查硬盘域后台均衡任务BUGLIST202106090003
    """
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    context["checkState"] = common.PROCESS_STATE_CHECKING
    common.threadUp(context, ITEM_ID, CHECK_BALANCE_TASK_TIMES)

    tool_context = UpgradeEvalContext(context)
    context_evaluation = tool_context.get_context()
    pool_balance_task_check = PoolBalanceTaskCheck(context_evaluation)
    try:
        flag, msg = pool_balance_task_check.check_all_ctrl_task()
        logger.logInfo("flag:{}, msg:{}".format(flag, msg))
        res_flag, ret, msg = \
            tool_context.get_result(flag, msg,
                                    pool_balance_task_check.get_origin_info())
        return res_flag, ret, msg
    except Exception as exception:
        logger.logException(exception)
        cli_ret = pool_balance_task_check.get_origin_info()
        err_key = "query.result.abnormal"
        return common.getUpgEvaluationRs(False, cli_ret,
                                         common.getMsg(lang, err_key))
    finally:
        common.finishProcess(context, ITEM_ID)
