# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

SNAP_SCHEDULE_RESULT_KEY = 'Upgrade Or Not'
CHECK_FEATURE_KEY = {
    'SnapSchedule': 'Upgrade Or Not',
    'HyperCDP': 'HyperCDP Upgrade Or Not',
    'HyperCopy': 'HyperCopy Upgrade Or Not'
}


def execute(context):
    status, cliRet, errMsg = check(context)
    return common.getUpgEvaluationRs(status, cliRet, errMsg)


def check(context):
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    cliRet = ''
    try:
        cmd = "show space global_config"
        flag, cliRet, msg = cliUtil.excuteCmdInDeveloperMode(cli, cmd, False, lang)
        # 命令不存在，不涉及
        if not cliUtil.hasCliExecPrivilege(cliRet):
            return (cliUtil.RESULT_NOSUPPORT, cliRet, msg)

        if flag == False:
            return (cliUtil.RESULT_NOCHECK, cliRet, msg)

        if flag != True:
            return (flag, cliRet, msg)

        if SNAP_SCHEDULE_RESULT_KEY not in cliRet:
            return (cliUtil.RESULT_NOSUPPORT, cliRet, msg)

        cliRetDictList = cliUtil.getVerticalCliRet(cliRet)
        if cliRetDictList is None or len(cliRetDictList) == 0:
            return (cliUtil.RESULT_NOCHECK, cliRet,
                                             common.getMsg(lang, 'query.result.abnormal'))
        cliRetDict = cliRetDictList[0]
        resultDict = {}

        for feature in CHECK_FEATURE_KEY:
            key = CHECK_FEATURE_KEY.get(feature)
            status = cliRetDict.get(key)
            if status and status.lower() != 'true':
                resultDict[feature] = status.lower()

        # 没有异常的特性，检查通过
        if len(resultDict) == 0:
            return (True, cliRet, '')

        # 有异常的特性，在检查结果中报出具体的特性
        errMsg = ""
        for feature in resultDict:
            errMsg += common.getMsg(lang, feature + ".notpass")
        return (False, cliRet, errMsg)

    except Exception, exception:
        logger.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, 'query.result.abnormal'))