# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil

# VRC版本为以下版本
srcVrcVersionList = ["V300R001C00", "V300R001C01"]

# 目标版本应大于V300R001C20
leastTargetVersion = "V300R001C20"

# OS内部用户列表
OS_INNER_USER_LIST = ["bin", "adm", "lp", "sync", "shutdown", "halt", "mail", "operator", "games", "systemd-bus-proxy",
                      "systemd-network", "dbus", "nscd", "ntp", "tss", "daemon", "rpc", "nslcd"]

def execute(context):
    '''
    @summary: 用户冲突检查，
    C20版本切换OS新增了预置用户，老版本不能包含这些用户
    '''

    lang = contextUtil.getLang(context)
    cli = contextUtil.getSSH(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = ""
    errMsg = ""

    try:
        curVrcVersion = common.getVrcVersion(contextUtil.getCurVersion(context))
        targetVersion = common.formatVersion(contextUtil.getTargetVersion(context))

        # 检查是否特定支持的型号和升级路径
        if curVrcVersion not in srcVrcVersionList or targetVersion < leastTargetVersion:
            logger.logInfo("not support user conflict check.")
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, "")

        # 检查是否存在冲突的用户
        (ok, allUserNames, cliRet) = getAllUserNames(cli, logger, lang)
        if not ok:
            logger.logInfo("query user names error.")
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))
        conflictUserNames = list(set(OS_INNER_USER_LIST).intersection(set(allUserNames)))
        if len(conflictUserNames) != 0:
            conflictUserNameStr = ",".join(conflictUserNames)
            errMsg = common.getMsg(lang, "user.conflict.result", conflictUserNameStr)
            logger.logInfo("exist conflict user:%s" % conflictUserNameStr)
            return common.getUpgEvaluationRs(False, cliRet, errMsg)
        return common.getUpgEvaluationRs(True, cliRet, "")
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))

def getAllUserNames(cli, logger, lang):
    '''
    获取系统所有用户的名称
    :return: 1-执行结果，2-所有用户名称列表，3-命令原始信息
    '''
    cliRet = ""
    userNames = []
    cmd = "show user"
    (ok, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    logger.logInfo("cmd:[%s] result:[%s]" % (cmd, cliRet))
    if not ok:
        return (False, userNames, cliRet)

    cliRetDict = cliUtil.getHorizontalCliRet(cliRet)
    if len(cliRetDict) == 0:
        return (False, userNames, cliRet)
    for item in cliRetDict:
        userNames.append(item.get('Name'))
    return (True, userNames, cliRet)



