# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData

def execute(context):
    '''
    @summary: 系统文件共享服务检查
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = ""
    cliAllRet = ""
    
    try:
        flag = True
        errMsg = ""
        tlv = contextUtil.getTlvObj(context)
        checkItem = "CHECK_SOFTWARE_PROTOCOL"
        logger.logExecCmd(checkItem)
        #根据检查项获取配置字典值
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]
        recs = tlvUtil.getUpgradeRecords(tlv, checkItem)
        logger.logInfo("records=%s" % unicode(recs))
        
        #获取cli回显，保存在cliAllRet
        cli = contextUtil.getSSH(context)
        tmpflag, ctrlNameList = cliUtil.getCtrlNames(cli, logger, lang)
        if tmpflag == True:
            for ctrlName in ctrlNameList:
                cmd = "show cifs server_info controller=" + ctrlName
                checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang)
                cliRet = checkRet[1]
                if cliUtil.hasCliExecPrivilege(cliRet):
                    cliAllRet += cliRet
                else:
                    ## 命令不存在场景时，返回不涉及
                    return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliAllRet, "")
                cmd = "show nfs server_info controller=" + ctrlName
                checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang)
                cliRet = checkRet[1]
                if cliUtil.hasCliExecPrivilege(cliRet):
                    cliAllRet += cliRet
                else:
                    ## 命令不存在场景时，返回不涉及
                    return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliAllRet, "")
                
        for record in recs:
            result = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESULT"])
            nodeId = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["NODE_ID"])
            if result.isdigit():
                if result == "0":
                    result = "True"
                else:
                    result = "False"
            itemVal = itemDict.get(result, None)
            if itemVal is None:
                errMsg += common.getMsg(lang, "check.result.abnormal", nodeId)
                flag = False
                continue
            #只有status为False时才获取错误信息
            status = itemVal.get("status", None)
            if status is True:
                continue
            flag = flag and cliUtil.RESULT_WARNING
            errMsg += common.getMsg(lang, itemVal["msg"], nodeId)
        
        if cliAllRet == "" and flag == cliUtil.RESULT_WARNING:
            cliAllRet += "The system contains services using NAS protocols that do not support online upgrade."
            
        if cliAllRet == "" and flag == True:
            cliAllRet += "The system shared services are normal."
        
        return common.getUpgEvaluationRs(flag, cliAllRet, errMsg)
    
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliAllRet, common.getMsg(lang, "query.result.abnormal"))
    