
# -*- coding: UTF-8 -*-
from com.huawei.ism.tool.loganalyzer.silence import SilenceInvoke
from com.huawei.ism.tool.framework.platform.util import UserOpDataSaveUtil
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from xml.dom import minidom
import os
import shutil
import time
import traceback
import sys
import threading
import re

def reloadSysEncoding():
    try:
        reload(sys)
        sys.setdefaultencoding('utf-8')
    except:
        pass


reloadSysEncoding()

DIR_RELATIVE_CMD = "..\.."

LOGGER = ''
SILENCECALL_TIME = 600
OTHER_EXECUTE_COMMAND = 10

# 原始信息显示行数
ORIGNAL_SHOW_CLI_LINES = 100

# 工具运行目录
BASE_ROOT_PATH = ''

# 收集的临时目录和上传目录
COLLECT_PATH_TEMP = "\\tools\\upgradeEvaluation\\check_log_collect\\"

# 日志解析规则文件路径
RULE_CONF_PATH = '\\tools\\upgradeEvaluation\\packages\\upgradeEvaluation\\conf'

CURRENT_PROGRESS = 1
TASK_FILE = "taskFile.xml"
PROGRESS_FILE = "Progress.xml"

# 临时的bat文件，用于执行静默调用
TEMP_BAT_FILE = "tmpCollectInfos.bat"

# 支持SSH跳转的版本
SUPPORT_SSH_FORWARD_TOOL_VERSION = "V2R3C00RC6"

#信息收集工具收集的日志路径
COLLECT_TOOL_DATA_PATH = ""

# actural OS(5)和session OS(7)误报、actural OS(1)和session OS(9)误打印
MISREPORT_OS_TYPE = {"5": "7", "1": "9"}


def execute(context):
    """
    @summary: 日志检查
    """
    global LOGGER, BASE_ROOT_PATH, COLLECT_PATH_TEMP, CURRENT_PROGRESS
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    devIp = contextUtil.getDevObj(context).getIp()
    devSn = contextUtil.getDevObj(context).getDeviceSerialNumber()
    lang = contextUtil.getLang(context)
    CURRENT_PROGRESS = 1
    refreshProgress(context, CURRENT_PROGRESS)
    cliRetList = []
    errMsgList = []
    BASE_ROOT_PATH = os.path.abspath(DIR_RELATIVE_CMD)
    try:

        isSuccess, errMsg = collectLog(context, devIp, devSn, lang)
        LOGGER.logInfo(
            "collectLog res is : isSuccess : %s, errMsg:%s, tool version:%s" % (isSuccess,
                                                                                errMsg,
                                                                                getCurrentToolkitVersion()))

        nowTime = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime())
        if not isSuccess:

            rmTempDir(devIp, devSn)

            cliRetList.append("%s %s" % (nowTime, common.getMsg(lang, "log.check.collect.fail")))

            # 如果是SSH跳转
            if not isNotSshForward(context) and getCurrentToolkitVersion() < SUPPORT_SSH_FORWARD_TOOL_VERSION:
                errMsg = common.getMsg(lang, "log.check.collect.fail.ssh.forward")

            LOGGER.logInfo("collectLog res is : errMsg:%s" % errMsg)

            # 如果是Socks5
            if not isNotSocks5Proxy(context) and getCurrentToolkitVersion() < SUPPORT_SSH_FORWARD_TOOL_VERSION:
                errMsg = common.getMsg(lang, "log.check.collect.fail.socks5")

            LOGGER.logInfo("collectLog res is : errMsg:%s" % errMsg)
            refreshProgress(context, 100)
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, "".join(cliRetList), errMsg)

        cliRetList.append("%s %s" % (nowTime, common.getMsg(lang, "log.check.collect.success")))

    except Exception, exception:
        refreshProgress(context, 100)
        rmTempDir(devIp, devSn)
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, "".join(cliRetList),
                                         common.getMsg(lang, "log.check.collect.fail"))

    try:
        refreshProgress(context, 99)

        analyzeResult = []
        logAnalyseThread = threading.Thread(target=silenceInvokeAnalyse, args=(context, devIp, devSn, lang, cliRetList, errMsgList, analyzeResult))
        logAnalyseThread.start()
        startTime = time.clock()
        while logAnalyseThread.isAlive():
            if time.clock() - startTime > 30*60:
                LOGGER.logInfo("call logAnalyse thread timeout.")
                flag = cliUtil.RESULT_NOCHECK
                cliRetList.append("log analyze timeout.")
                errMsg = common.getMsg(lang, "log.check.analyze.fail")
                refreshProgress(context, 100)
                return common.getUpgEvaluationRs(flag, "".join(cliRetList), errMsg)
            time.sleep(1)
        LOGGER.logInfo("threadRet" + str(analyzeResult))

        # 修正日志分析结果
        flag, cliRetList, errMsg = correct_analyser_result(analyzeResult)

        refreshProgress(context, 100)
        if flag is True:
            rmTempDir(devIp, devSn)
        return common.getUpgEvaluationRs(flag, "".join(cliRetList), errMsg)
    except:
        refreshProgress(context, 100)
        rmTempDir(devIp, devSn)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, "".join(cliRetList),
                                         common.getMsg(lang, "log.check.analyze.fail"))


def correct_analyser_result(analyze_result):
    """
    日志分析出的结果中存在一定的误报：
    已知：actural OS(5)和session OS(7)误报、actural OS(1)和session OS(9)误打印
    如果所有检查出来的不一致都是误报，则结果修正为True
    只要有一个主机类型不是误报，结果仍为False
    :return:
    """
    flag = analyze_result[0]
    cli_ret_list = analyze_result[1]
    err_msg = analyze_result[2]
    if flag is not False:
        # 只针对False进行修正，True，NOCHECK不处理
        return flag, cli_ret_list, err_msg

    pattern = "The actural OS\((\d+)\) of host.* is different from " \
              "configuration, session I_T.* OS\((\d+)\)"
    LOGGER.logInfo("correct_analyser_result, cli_ret=" + str(cli_ret_list))
    for line in cli_ret_list:
        matched = re.search(pattern, line)
        if matched and not is_os_type_misreport(
                    matched.group(1), matched.group(2)):
            return False, cli_ret_list, err_msg
    return True, cli_ret_list, ""


def is_os_type_misreport(actual_os, os_type):
    """
    检查主机类型是否误报
    :param actual_os: 多路径推送到SCSI的主机操作系统类型
    :param os_type: 主机配置的操作系统类型
    :return: 是否为误报的主机类型
    """
    return MISREPORT_OS_TYPE.get(actual_os) == os_type


def silenceInvokeAnalyse(context, devIp, devSn, lang, cliRetList, errMsgList, analyzeResult):
    collectDir = getCollectDir(devIp, devSn)

    # 规则文件路径
    rulePath = BASE_ROOT_PATH + RULE_CONF_PATH
    LOGGER.logInfo(
        "check log-- BASE_ROOT_PATH:%s, rulePath:%s, collectDir:%s" % (BASE_ROOT_PATH, rulePath, collectDir))

    # 构造日志分析的参数
    paramMap = {
        'logPackagePath': collectDir,
        'scriptPath': '',
        'rulePath': rulePath,
        'model': contextUtil.getDevType(context),
        'version': contextUtil.getCurVersion(context),
        'lan': lang
    }

    LOGGER.logInfo("check log analyse start paramMap: %s" % paramMap)

    resMap = SilenceInvoke.analyse(paramMap)

    isSuccess = resMap.get("isSuccess")
    LOGGER.logInfo("check log analyse start isSuccess: %s" % isSuccess)

    if not isSuccess:

        errMsg = resMap.get("errMsg")

        LOGGER.logInfo("check log analyse res isSuccess: %s, errMsg:%s" % (isSuccess, errMsg))

        if errMsg is None or not errMsg:
            errMsg = common.getMsg(lang, "log.check.analyze.fail")

        cliRetList.append(errMsg)

        analyzeResult.extend([cliUtil.RESULT_NOCHECK, cliRetList, errMsg])
        return

    cliRetList.append(common.getMsg(lang, "log.check.collect.cliRetTitle"))

    ruleList = resMap.get('ruleList')

    LOGGER.logInfo("check log analyse res ruleList: %s" % ruleList)

    index = 1
    for rule in ruleList:
        ruleName = rule.getName()
        ruleErrMsg = rule.getErrMsg()
        showInfoList = rule.getShowInfo()
        errMsgList.append("\n%s" % ruleErrMsg)
        cliRetList.append("%s. [%s]\n" % (index, ruleName))
        showCount = 0
        for recordInfo in showInfoList:
            if showCount >= ORIGNAL_SHOW_CLI_LINES:
                break
            # stringBuilder对象转换为Python的string.
            LOGGER.logInfo(
                "check log analyse res ruleList filePath: %s\n %s" % (recordInfo.getFilePath, recordInfo.getContent()))
            cliRetList.append("   %s" % recordInfo.getContent())
            showCount += 1
        index += 1

    if ruleList:
        analyzeResult.extend([False, cliRetList, "\n".join(errMsgList)])
        return

    cliRetList = [common.getMsg(lang, "log.check.collect.successCliRetTitle")]
    analyzeResult.extend([True, cliRetList, ''])
    return


def getCurrentToolkitVersion():
    try:
        return UserOpDataSaveUtil.getToolBoxIniProp("app.version").split()[-1]
    except Exception, e:
        LOGGER.logException(e)
        return ""


def isNotSshForward(context):
    """
    @summary: 是否是SSH跳转
    @return: True 不是SSH跳转， False 是SSH跳转。
    """
    try:
        return context.get("dev").isNotSshForward()
    except:
        LOGGER.logError(traceback.format_exc())
        return True


def isNotSocks5Proxy(context):
    """
    @summary: 是否是Socks5代理
    @return: True 不是Socks5代理， False 是Socks5代理。
    """
    try:
        socks5Proxy = context.get("dev").getSocks5Proxy()
        if socks5Proxy and socks5Proxy.getServerIp():
            return False
        else:
            return True
    except:
        LOGGER.logError(traceback.format_exc())
        return True


def rmTempDir(ip, sn):
    """
    @summary: 删除临时目录
    """
    try:
        collectPath = BASE_ROOT_PATH + COLLECT_PATH_TEMP + "\\" + ip + "_" + sn
        shutil.rmtree(collectPath)
    except Exception, e:
        LOGGER.logException(e)
    try:
        os.remove(TEMP_BAT_FILE)
    except Exception, e:
        LOGGER.logException(e)

    try:
        os.remove(BASE_ROOT_PATH + COLLECT_PATH_TEMP + TASK_FILE)
    except Exception, e:
        LOGGER.logException(e)


def getCollectDir(ip, sn):
    """
    @summary: 信息收集完会自动创建一层目录
    @return collectDir: 返回日志压缩包路径
    """
    collectDir = BASE_ROOT_PATH + COLLECT_PATH_TEMP
    fileList = os.listdir(collectDir)
    dirName = "%s_%s" % (ip, sn)
    # 由于收集完成后还有一层目录，拼接出日志路径
    for filePath in fileList:
        if os.path.isdir(collectDir + "\\" + filePath) and dirName in filePath:
            collectDir += "\\" + filePath
            return collectDir
    return collectDir


def collectLog(context, devIp, devSn, lang, progressTime=120.0):
    """
    @summary: 查看进度条
    """
    isNeedSilence = isNeedSilenceCollect(context)
    if not isNeedSilence:
        return True, ''

    global CURRENT_PROGRESS
    # 每次轮巡睡眠时间
    intevalTime = 1

    singleProgress = (99.0 / progressTime) * intevalTime

    # 参考信息收集超时时间
    toolTimeOut = 1200

    # progress
    waitProgressTimeOut = 60

    while True:
        try:
            progressMap = getProgressByXml(BASE_ROOT_PATH + COLLECT_PATH_TEMP + PROGRESS_FILE, devIp)
            deviceProgress = progressMap.get(devIp + devSn)
            if not deviceProgress:
                deviceProgress = {}
            status = deviceProgress.get("status")
            result = deviceProgress.get("result")

            if status == 'finished' or result == 'failed' or result == 'success':
                if CURRENT_PROGRESS == 1:
                    # 刷新进度平滑
                    for i in range(1, 10):
                        refreshProgress(context, i * 10)
                        safeSleep(intevalTime)
                refreshProgress(context, 99)
                LOGGER.logInfo("check log --collect end")
                if result == 'failed':
                    return False, common.getMsg(lang, "log.check.collect.fail")
                return True, ''
            else:
                CURRENT_PROGRESS += singleProgress
                refreshProgress(context, int(CURRENT_PROGRESS))
                toolTimeOut -= intevalTime
                if toolTimeOut < 0:
                    return False, common.getMsg(lang, "log.check.collect.fail")
        except:
            LOGGER.logInfo("get progress file exception")
            toolTimeOut -= intevalTime
            waitProgressTimeOut -= 1
            if waitProgressTimeOut < 0:
                return False, common.getMsg(lang, "log.check.collect.fail")
            CURRENT_PROGRESS += singleProgress
            refreshProgress(context, int(CURRENT_PROGRESS))

        safeSleep(intevalTime)


def refreshProgress(context, percentNumber):
    """
    刷新进度
    """
    try:
        if int(percentNumber) < 1 or int(percentNumber) > 99:
            return
    except:
        LOGGER.logError(traceback.format_exc())
        return

    dev = context.get("dev")
    observer = context.get("progressObserver")
    try:
        if observer is not None:
            observer.updateItemProgress(dev, int(percentNumber), "tlv_software_log")
    except:
        LOGGER.logInfo("refresh progress exception.")
        LOGGER.logError(traceback.format_exc())


def getProgressByXml(path, devIp):
    """
    根据progress.xml刷新进度。
    """
    # 判断path是否存在
    doc = minidom.parse(path)
    root = doc.documentElement
    deviceNodeList = root.getElementsByTagName("device")
    progressMap = {}
    for deviceNode in deviceNodeList:
        # 状体，是否完成 finished
        status = deviceNode.getAttribute("status")
        # 进度，1-100字符
        progress = deviceNode.getAttribute("progress")
        # 结果 failed
        result = deviceNode.getAttribute("result")

        serialNo = deviceNode.getAttribute("serialNo")

        progressMap[devIp + serialNo] = {"status": status,
                                         "progress": progress,
                                         "result": result,
                                         }
    LOGGER.logInfo("refresh progress: progressMap is :%s" % progressMap)
    return progressMap


def safeSleep(seconds):
    """
    @summary: 安全睡眠时间
    @param seconds: seconds为睡眠时间，单位：秒；数据类型：整数或小数
    """
    try:
        if type(seconds) not in [int, long, float] or seconds <= 0:
            return

        startTime = time.time()
        while True:
            if (time.time() - startTime) >= seconds:
                return

            # 睡眠一下，避免长时间占用cpu，该时间设置过长会影响睡眠时间精度
            try:
                time.sleep(0.5)
            except:
                pass
    except:
        return

def isNeedSilenceCollect(context):
    '''判断是否需要静默收集日志，若不需要，则从上下文中获取日志路径'''
    global COLLECT_TOOL_DATA_PATH
    dev = contextUtil.getDevObj(context)
    devIp = dev.getIp()
    devSn = dev.getDeviceSerialNumber()
    if dev.isNeedLog():
        LOGGER.logInfo("[isNeedSilenceCollect]need silence collect.")
        return True
    collectFile = dev.getExtraMap().get("collectFile")
    LOGGER.logInfo("[isNeedSilenceCollect]get collect file from dev: %s" % collectFile)
    if collectFile and collectFile != "":
        collectDir = BASE_ROOT_PATH + COLLECT_PATH_TEMP
        dirName = "%s_%s" % (devIp, devSn)
        collectDir = os.path.join(collectDir, dirName)
        LOGGER.logInfo("[isNeedSilenceCollect]collectDir: %s" % collectDir)
        if not os.path.exists(collectDir):
            flag = os.makedirs(collectDir)
            LOGGER.logInfo("[isNeedSilenceCollect]makedirs: %s" % flag)
        shutil.copy(collectFile, collectDir)
        LOGGER.logInfo("[isNeedSilenceCollect]copy: %s" % collectDir)
        return False
    return True