# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData

def execute(context):
    '''
    @summary: 系统配置数据检查
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = ""
    
    try:
        flag = True
        errMsg = ""
        tlv = contextUtil.getTlvObj(context)
        checkItem = "CHECK_SOFTWARE_SYS_CONFIGLOG"
        logger.logExecCmd(checkItem)
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]#根据检查项获取配置字典值
        recs = tlvUtil.getUpgradeRecords(tlv, checkItem)
        logger.logInfo("records=%s" % unicode(recs))
        
        #获取cli回显，保存在cliRetList
        cli = contextUtil.getSSH(context)
        cmdList = []
        cmdList.append("sys showcfglog")
        cliRetList = cliUtil.GetCliRecsInDebugMode(cli, cmdList, logger, lang)
        cliRet = "\n".join(cliRetList)
        
        for record in recs:
            result = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESULT"])
            itemVal = itemDict.get(result, None)#根据模块返回值获取对应的字典值,如果失败返回None
            if itemVal is None:
                itemVal = itemDict["True"]#消息返回值不在字典中,放过检查项以支持版本的兼容性.
            status = itemVal.get("status", None)
            if status is True:
                continue
            flag = False
            errMsg += common.getMsg(lang, itemVal["msg"])
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))