# -*- coding: UTF-8 -*-
from frame.common import common
from frame.context import contextUtil
from frame.cli import cliUtil
import shutil
import os

#==============================================================================
# 评估最后执行脚本，做收尾工作 。如使用CLI命令关闭TLV通道。                                                                                     19:59 2016/1/21
#==============================================================================
def execute(context):
    
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    lang = contextUtil.getLang(context)
    
    errMsg = ""
    #关闭tlv通道，不管关闭是否成功不影响工具正常运行。
    openFlag, openRet = cliUtil.closeTlvChannel(cli, lang)
    if not openFlag:
        errMsg = "open failed!"
    logger.logInfo("close status is[%s]" % openFlag)

    try:
        collectTmpDir = contextUtil.getCollectTmpDir(context)
        if collectTmpDir and os.path.exists(collectTmpDir):
            shutil.rmtree(collectTmpDir, ignore_errors = True)
        logger.logInfo("Delete temp alarm file succeed. dir: %s" % str(collectTmpDir))
    except Exception, ex:
        logger.logException(ex)

    
    return (common.RESULT_PASS, openRet, errMsg)