# -*- coding: UTF-8 -*-
SCRIPT_DEF_CONTEXT = "SCRIPT_DEF_CONTEXT"

def getLang(context):
    '''
    @summary: 获取语言
    @param context: 上下文对象
    '''
    return context.get("lang")

def getLogger(context):
    '''
    @summary: 获取日志打印对象
    @param context: 上下文对象
    '''
    return context.get("logger")

def getSFTP(context):
    '''
    @summary: 获取工具与阵列的SFTP连接对象
    '''
    return context.get('sftp')

def getDevType(context):
    '''
    @summary: 获取设备类型
    '''
    return getDevObj(context).getDeviceModel()

def getDevSN(context):
    '''
    @summary: 获取设备序列号Serial Number
    '''
    return getDevObj(context).getDeviceSerialNumber()

def getCurVersion(context):
    '''
    @summary: 获取系统当前版本
    @param context: 上下文对象
    '''
    return getDevObj(context).getProductVersion()

def getTargetVersion(context):
    '''
    @summary: 获取目标版本号
    @param context: 上下文对象
    '''
    return getDevObj(context).getDestVersion()

def getScriptDefDict(context):
    '''
    @summary: 获取上下文自定义字典
    @param context: 上下文对象
    '''
    if isinstance(context, dict):
        if not context.has_key(SCRIPT_DEF_CONTEXT):
            context.setdefault(SCRIPT_DEF_CONTEXT, {})
    else:
        if not context.containsKey(SCRIPT_DEF_CONTEXT):
            context.put(SCRIPT_DEF_CONTEXT, {})
    return context.get(SCRIPT_DEF_CONTEXT)

def setItem(context, key, value):
    '''
    @summary: 往自定义字典中添加项
    @param context: 上下文对象
    @param key: 添加项的键
    @param value: 添加项的值
    '''
    scriptDefDict = getScriptDefDict(context)
    scriptDefDict[key] = value
    
    if isinstance(context, dict):
        context[SCRIPT_DEF_CONTEXT] = scriptDefDict.copy()
    else:
        context.put(SCRIPT_DEF_CONTEXT, scriptDefDict.copy())
    return

def removeItem(context, key):
    '''
    @summary: 删除自定义字典中的项
    @param context: 上下文对象
    @param key: 删除项的键
    '''
    scriptDefDict = getScriptDefDict(context)
    if scriptDefDict.has_key(key):
        scriptDefDict.pop(key)
    return

def getItem(context, key):
    '''
    @summary: 获取自定义字典中的项
    @param context: 上下文对象
    @param key: 项的键
    '''
    scriptDefDict = getScriptDefDict(context)
    return scriptDefDict.get(key, None)

def getConnectorFactoryObj(context):
    '''
    @summary: 获取上下文对象中创建连接的对象
    @param context: 上下文对象
    '''
    return context.get("sshFactory")

def getNewDevObj(context):
    '''
    @summary: 获取上下文对象中dev_rest对象
    @param context: 上下文对象
    '''
    return context.get("newDev")

def getDevObj(context):
    '''
    @summary: 获取上下文对象中dev对象
    @param context: 上下文对象
    '''
    return context.get("dev")

def getLoginUserName(context):
    '''
    @summary: 获取登录用户名
    '''
    return getDevObj(context).getLoginUser().getUserName() 

def getDevLoginUserPwd(context):
    '''
    @summary: 获取上下文对象中dev对象中的的登录密码
    @param context: 上下文对象
    '''
    dev = getDevObj(context)
    return dev.getLoginUser().getPassword()

def getDeveloperPwd(context):
    '''
    @summary: 获取developer密码
    @param context: 上下文对象
    '''
    return getDevObj(context).getDeveloperPwd()

def getDevPort(context):
    '''
    @summary: 获取上下文对象中dev对象中的的登录端口
    @param context: 上下文对象
    '''
    dev = getDevObj(context)
    return dev.getPort()

def getTmpDir(context):
    '''
    @summary: 获取子工具运行根目录下的临时目录
    '''
    return context.get('tmpDir')


def getUpgradeModel(context):
    '''
    @summary: 获取升级模式（在线或者离线），其值为"ONLINE"或"OFFLINE"
    @param context: 上下文对象
    '''
    return str(getDevObj(context).getUpgradeMode())

def getCli(context):
    return context.get('ssh')
