# -*- coding: UTF-8 -*-
from cbb.frame.rest.restUtil import Tlv2Rest
from cbb.frame.context import contextUtil

CMD_DEFAULT_TIMEOUT = 60 * 2

CMO_SUPPORT_FLAG = {"index": 64, "type": "boolean"}
CMO_TARGET_VERSION = {"index": 65, "type": "string"}
CMO_CURRENT_VERSION = {"index": 66, "type": "string"}

CMD_QUERY_APOLLO_SUPPORT = {'cmd': 59594908204, 'timeout': CMD_DEFAULT_TIMEOUT}


def execute(context):
    rest = contextUtil.getRest(context)
    recs = Tlv2Rest.execCmd(rest, CMD_QUERY_APOLLO_SUPPORT, [])
    rec = recs[0]
    support_flag = Tlv2Rest.getRecordValue(rec, CMO_SUPPORT_FLAG)
    target_version = Tlv2Rest.getRecordValue(rec, CMO_TARGET_VERSION)
    current_version = Tlv2Rest.getRecordValue(rec, CMO_CURRENT_VERSION)
    return support_flag, current_version, target_version
