# -*- coding: UTF-8 -*-
import copy

from cbb.business.checkitems import SystemInnerCheck
from cbb.business.collect.hostinfo.collect_host_info_util import (
    is_need_collect_host_info,
    is_support_collect_host_info,
)
from cbb.business.collect.hostinfo.collect_host_info import (
    collect_4_download_path,
    after_collect_host_info,
)
from cbb.frame.base import baseUtil

from common import common


# 升级前检查类型,目前产品未对Apollo适配升级评估，暂时走滚动升级的评估项
SYS_UPG_CHECK_TYPE = {
    'FAST': 'FastUpgradeEvaluate',
    'ONLINE': 'RollUpgradeEvaluate',
    'OFFLINE': 'OfflineEvaluate',
    'APOLLO': 'RollUpgradeEvaluate',
    'APOLLO_PARALLEL': 'OfflineEvaluate',
}
# 界面状态 com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag
STATUS_MAP_DICT = {
    "0": 7,  # 等待执行
    "1": 6,  # 执行中
    "2": 0,  # 执行成功
    "3": 1,  # 执行失败
    "4": 2,  # 执行错误
    "5": 3,  # 忽略
}
ITEM = "preUpgradeInnerCheck"


def execute(dataDict):
    dataDict['checkType'] = "PRECHECK"
    logger = dataDict.get("logger")
    dev = dataDict.get("dev")
    upgradeType = str(dev.getUpgradeMode())
    logger.info("[PreCheck]user setted upgrade type is :" + upgradeType)
    common.setProgress(dataDict, common.PROGRESS_NUM_5, ITEM)
    # 免主机收集
    params_dict = copy.copy(dataDict)

    collect_params = get_collect_params(context=params_dict)
    download_path = collect_host_info(params_dict, collect_params)
    logger.info("download_path:{}".format(download_path))
    common.setProgress(dataDict, common.PROGRESS_NUM_60, ITEM)

    context = dataDict
    observer = UiObserver(dataDict)
    context["checkType"] = SYS_UPG_CHECK_TYPE.get(upgradeType)
    
    context["observer"] = observer
    context["ignorePreCheckItems"] = dataDict.get("ignorePreCheckItems", "")
    context["supportItemsIgnore"] = dataDict.get('supportItemsIgnore')
    extras = {
        "targetVersion": str(dev.getDestVersion().split()[0]),
        "hostInfoPkgPath": download_path,
    }
    context["extras"] = extras
    logger.info("xx send extras=%s" % str(extras))
    common.setProgress(dataDict, 99, ITEM)
    check_obj = SystemInnerCheck.UpgradeCheck(context)

    flag, errMsg, originalInformation = check_obj.execute()
    # 返回的格式：（检查结果，原始信息，错误描述）
    common.setProgress(dataDict, common.PROGRESS_NUM_MAX, ITEM)

    if download_path:
        after_collect_host_info(collect_params)

    if flag:
        return "0", originalInformation, ""
    return "1", originalInformation, errMsg


class UiObserver():
    def __init__(self, dataDict):
        self.dataDict = dataDict
        self.logger = dataDict.get("logger")
        self.resource = dataDict.get("resource")
        self.lang = dataDict.get("lang")
        self.currentEvauItem = dataDict.get("")
        self.uiUpdateMsg = {}
        self.dev = self.dataDict.get("dev")
        self.uiObserver = self.dataDict.get("progressObserver")

    def postMsg(self, innerItems):
        # 先移除所有老的内部检查项，再加上新的
        self.uiUpdateMsg["checkitems"] = innerItems
        self.uiObserver.updateChildItems(
            self.dev,
            "preUpgradeInnerCheck",
            self.uiUpdateMsg)

    def toUiStatus(self, status):
        return STATUS_MAP_DICT.get(status, 7)

    def setProgress(self, progress):
        progress = int(progress*0.9)
        # 执行下沉检查项的检查前，进度已经是1%了；int()是向下取整，可能会小于1；
        if progress <= 1:
            progress = 1
        self.dev.setEvaluProgress(progress)
        self.uiObserver.updateDevTableRow(self.dev)


class CheckStatus:
    PASS = "0"
    NOTPASS = "1"
    NOCHECK = "2"
    NO_SUPPORT = "3"
    WARNING = "4"


def get_collect_params(context):

    dev_node = context["dev"]
    params_dict = copy.copy(context)
    params_dict.update({
        "context": context,
        "devNode": dev_node,
        "devIp": dev_node.getIp(),
        "SSH": context["ssh"],
        "SFTP": context["sftp"],
        "toolDir": context["toolDir"],
        "upgradeTargetVersion": str(dev_node.getDestVersion().split()[0]),
        "upgradeExtend": {
            "upgradeMode": dev_node.getUpgradeModeUI().toString(),
            "stopBusiness": "true" if dev_node.isStopHostBusiness()
            else "false",
        },
    })
    return params_dict


def collect_host_info(context, collect_params):
    logger = context.get("logger")
    dev_node = context["dev"]

    # 获取阵列版本，不带Kunpeng
    dev_ver = collect_params["devNode"].getProductVersion().split()[0]
    dev_type = str(dev_node.getDeviceType())
    logger.info("dev version:{}".format(dev_ver))
    if not is_collect_host_version(dev_type, dev_ver):
        logger.info("is_collect_host_version: False")
        return ""

    logger.info("start collect host info for pre upgrade inner check.")
    if not is_support_collect_host_info(collect_params):
        logger.info("is_support_collect_host_info: False")
        return ""
    common.setProgress(context, common.PROGRESS_NUM_10, ITEM)
    if not is_need_collect_host_info(collect_params):
        logger.info("is_need_collect_host_info: False")
        return ""
    common.setProgress(context, common.PROGRESS_NUM_20, ITEM)

    path = collect_4_download_path(collect_params) or "error"
    return "{}:{}".format(dev_node.getIp(), path)


def is_collect_host_version(dev_type, version):
    """
    是否支持主机信息收集的版本
    支持的版本：V5R7C71及以后版本，Dorado 6.1.RC2及以后版本
    :param dev_type: 设备型号。
    :param version: 版本
    :return: 是否支持
    """

    # 设备为 二级存储，新融合，微存储的设备都支持主机信息收集。
    if any([baseUtil.is_ocean_protect(dev_type), baseUtil.is_new_oceanstor(dev_type),
            baseUtil.is_micro_dev(dev_type), baseUtil.is_computing_dev(dev_type)]):
        return True

    if not isinstance(version, basestring):     # noqa
        return False

    version = version.upper().strip()
    if version.startswith("V500R007") and version >= "V500R007C71":
        return True
    elif version.startswith("6.1"):
        return not (
                version.startswith("6.1.RC1") or version.startswith("6.1.RC2")
        )
    elif version.startswith("6") and version > "6.2":
        return True

    return False
