# -*- coding: UTF-8 -*-
import re
import traceback
from cBase4TV1 import *

P_Contain = 0
P_Start = 1
P_End = 2

# *****************************************************************************************#
# 类名称: getLocation(cliRet, subStr, relation = P_Contain)
# 功能说明: 在CLI回显中找到（或以subStr开始，结尾）第一次出现subStr的位置
# 输入参数: cliRet, subStr（字串）, relation = P_Contain（默认为找到）
# 输出参数: location
# *****************************************************************************************#
def getLocation(cliRet, subStr, relation=P_Contain, startIndex=0):
    location = -1
    
    cliRetList = cliRet.splitlines()
    for i in xrange(startIndex, len(cliRetList)):
        lineInfo = cliRetList[i].strip()
        if P_Contain == relation and -1 != lineInfo.find(subStr):
            location = i
            break
        elif P_Start == relation and lineInfo.startswith(subStr):
            location = i
            break
        elif P_End == relation and lineInfo.endswith(subStr):
            location = i
            break
    return location
 
          
class cliRetHorizontal(cHorizontal):
    """
    # *****************************************************************************************#
    # 类名称: cliRetHorizontal（继承cHorizontal）
    # 功能说明:处理下面格式的回显信息，返回list(dict)结构，value值的行数即为list的长度
    #admin:/>showrg
    #=============================================================================
    #                           RAID Group Information
    #-----------------------------------------------------------------------------
    #  ID    Level    Status    Free Capacity(MB)    Disk List           Name     
    #-----------------------------------------------------------------------------
    #  0     RAID6    Normal    2783488              1,0;1,1;1,2;1,3;    RAID001  
    #=============================================================================
    # 输入参数: cliRet：开始某行为key值，下方为对应value值CLI回显格式 
    #           newLineSign：对于value值存在多行的情况，默认为直接连接
    #           areaIndex = [key预计起始位置，value预计结束位置]：指定回显需要处理的范围，默认全部
    # 输出参数: handle函数：返回（list(dict)）
    #           getKeyOrder函数：返回key值在原始回显中的顺序
    #           getKeyLine函数：返回key值所在的行
    #           getValIndex函数：返回key值对应val的起始位置信息
    # *****************************************************************************************# 
    """
    def __init__(self, cliRet, newLineSign="", areaIndex=[None, None]):
        self.__keyLineInfo = "" #key值所在行的信息
        self.__keyOrder = []    #key值顺序列表
        self.__totalValIndexDict = {} #key值对应val的起始位置信息
        fstKeyEndIndex = -1
        keyIndexInfoDict = {}
        
        if not self.__checkParams(cliRet, areaIndex):
            raise ParseException("Input param error(cliRet=" + unicode(cliRet) + \
                            ",newLineSign=" + unicode(newLineSign) + ",areaIndex=" + unicode(areaIndex) + ")")
        
        cliRet = cliRet.encode('utf8')
        
        #获取指定区域的CLI回显list，默认处理全部
        cliRetList = self.__(cliRet, areaIndex)
        if not cliRetList:
            raise ParseException()
        
        #获取keyWord在指定区域中所在行数的索引
        keyPos = self.__getKeyPos(cliRetList)
        if -1 == keyPos:
            raise ParseException() 
       
        #设置包含key值的行
        self.__keyLineInfo = cliRetList[keyPos]
        
        #获取所有key值及对应的value值的起始位置
        self.__totalValIndexDict = self.__getTotalKeyIndexInfo()
        
        #获取第一个key值对应的结束标志
        fstKeyEndIndex = self.__getFirstKeyEndIndex()
        
        cHorizontal.__init__(self, cliRetList[keyPos + 1:len(cliRetList)], fstKeyEndIndex, self.__totalValIndexDict, newLineSign)
        return 

    #入参检查
    def __checkParams(self, cliRet, areaIndex):
        if not cliRet:
            return False
        if list != type(areaIndex) and 2 == len(areaIndex):
            return False
        return True
    
    #获取需要处理区域的CLI回显，请传入一个表头+N个value行的结构     
    def __(self, cliRet, areaIndex=[None, None]):
        cliRetList = cliRet.splitlines()
        if [None, None] == areaIndex:
            return cliRetList
        elif areaIndex[0] > 0 and None == areaIndex[1]:
            return  cliRetList[areaIndex[0]:len(cliRetList)] 
        elif [None, None] != areaIndex:
            if 2 != len(areaIndex) or areaIndex[0] >= areaIndex[1]:
                return None
            return  cliRetList[areaIndex[0]:areaIndex[1]]
        else:
            return cliRetList
    
    #针对横向CLI回显结果，获取key值所在行，原则为第一个出现字符用两个及以上空格分隔的情况
    def __getKeyPos(self, cliRetList):
        
        if not cliRetList:
            return -1
        
        #查找
        for i in xrange(0, len(cliRetList)):
            if not re.search("[A-Za-z0-9]", cliRetList[i]):
                continue
            
            elif patternEnd.match(cliRetList[i]):
                continue
            
            #两个空格之后为非字母，一定非keyWord行
            elif re.search("\s{2,}[^a-zA-Z\s]", cliRetList[i]):
                continue
            
            #找到两个及以上“  字母”格式，即可判断为包含keyWord的行
            elif len(re.findall("\s{2,}[a-zA-Z]", cliRetList[i])) >= 2:
                return i
        return -1
    
    #获取所有关键字对应value值的起始位置
    def __getTotalKeyIndexInfo(self):
        
        totalkeyIndexDict = {}  
        
        __keyLineInfo = unicode(self.__keyLineInfo.title().decode('utf8'))
        
        sList = re.split("\s{2,}", __keyLineInfo.strip())
        
        valsIndex = []
        for key in sList:
            self.__keyOrder.append(key.strip())
            valsIndex.append(__keyLineInfo.find(key, valsIndex[-1] + 1 if len(valsIndex) > 0 else 0))    
        valsIndex.append(len(__keyLineInfo))
            
        #循环所有key找到对应value的起始位置        
        for i in xrange(len(sList)):
            key = sList[i].strip()
            totalkeyIndexDict[key] = [valsIndex[i], valsIndex[i + 1]]
            
        return totalkeyIndexDict
    
    #获取第一个key值的结束位置
    def __getFirstKeyEndIndex(self):
        __keyLineInfo = self.__keyLineInfo.strip()
        
        index = __keyLineInfo.find("  ")
        if -1 == index:
            return -1
        else:
            return index + 2
     
    def getKeyOrder(self):
        """
        返回key值在CLI回显中的顺序
        """
        return self.__keyOrder
     
    def getKeyLine(self):
        """
        返回key值所在行的信息
        """
        return self.__keyLineInfo
    
    def getValIndex(self):
        """
        返回val对应的起始坐标信息
        """
        return self.__totalValIndexDict
    
    def handle(self, isAlign=False):
        """
        返回CLI回显解析结构
        """
        return cHorizontal.handle(self, isAlign)
    
class cliRetVertical(cVertical):
    """
    # *****************************************************************************************#
    # 函数名称: cliRetVertical（cVertical）
    # 功能说明: 处理下面格式的回显信息，返回list(dict)结构
    # admin:/>showsys
    # ==============================================================================
    #                  System Information
    # ------------------------------------------------------------------------------
    # System Name           | SN_210235G6KD123456789A
    # Device Type           | OceanStor S5800T
    # Current System Mode   | Double Controllers Normal
    # Mirroring Link Status | Link Up
    # Location              | 
    # Time                  | 2015-04-03 18:05:11
    # Device Serial Number  | 210235G6KD123456789A
    # Product Version       | V100R005C30
    # iSCSI Device Name     | iqn.2006-08.com.huawei:oceanstor:21000022a10bee8b:
    # ==============================================================================
    # 输入参数: cliRet：CLI回显
    #           defaultSep：默认分隔符为"|"
    #           newLineSign：对于value值存在多行的情况，默认为直接连接
    # 输出参数: handle函数：返回（list(dict)）
    #           getKeyOrder函数：返回key值在原始回显中的顺序
    # *****************************************************************************************#
    """
    def __init__(self, cliRet, defaultSep="|", newLineSign=""):
        cVertical.__init__(self, cliRet, defaultSep="|", newLineSign="")
        return

    def handle(self):
        """
        返回CLI回显解析结构
        """
        return cVertical.handle(self)
    
    def getKeyOrder(self):
        """
        返回key值在CLI回显中的顺序
        """
        return cVertical.getKeyOrder(self)

class cHandleCliRet(cliRetHorizontal, cliRetVertical):
    # *****************************************************************************************#
    # 函数名称: cHandleCliRet(cliRetHorizontal, cliRetVertical)
    # 功能说明: 针对TV1 CLI回显信息，自动调用横向或是纵向接口进行解析
    # 输入参数: cliRet：CLI回显
    #           areaIndex：处理区域
    #           defaultSep：默认分隔符为"|"
    #           newLineSign：对于value值存在多行的情况，默认为直接连接
    # 输出参数: handle函数：返回（list(dict)）
    #           getKeyOrder函数：返回key值在原始回显中的顺序
    #           getCliRetType函数：返回当前CLI回显所属的类型
    # *****************************************************************************************#
    __cliRetType = ""
    def __initCliRetType(self, cliRet, defaultSep="|"):
        cliRetList = cliRet.splitlines()
        
        for i in xrange(2, len(cliRetList) - 1):
            if not re.search("[A-Za-z0-9]", cliRetList[i]):
                continue
            
            elif patternEnd.match(cliRetList[i]):
                continue
            
            #两个空格之后为非字母，一定非keyWord行
            elif re.search("\s{2,}[^a-zA-Z\s]", cliRetList[i]):
                continue
            
            #找到两个及以上“  字母”格式，即可判断为包含keyWord的行
            elif (len(re.findall("\s{2,}[a-zA-Z]", cliRetList[i])) >= 2)\
                 and patternSub.match(cliRetList[i - 1]) \
                 and patternSub.match(cliRetList[i + 1]):
                return "Horizontal"
        return "Vertical"
        
    def __init__(self, cliRet, areaIndex=[None, None], defaultSep="|", newLineSign=""):
        self.__cliRetType = self.__initCliRetType(cliRet, defaultSep)
        if "Horizontal" == self.__cliRetType:
            cliRetHorizontal.__init__(self, cliRet, newLineSign="", areaIndex=[None, None])
        elif "Vertical" == self.__cliRetType:
            cliRetVertical.__init__(self, cliRet, defaultSep="|", newLineSign="")
        else:
            raise ParseException
        return
    
    def handle(self):
        """
        返回CLI回显解析结构
        """
        if "Horizontal" == self.__cliRetType:
            return cliRetHorizontal.handle(self, isAlign=False)
        elif "Vertical" == self.__cliRetType:
            return cliRetVertical.handle(self)

    def getCliRetType(self):
        """
        返回CLI回显结构是横向还是纵向结构
        """
        return self.__cliRetType
     
    def getKeyOrder(self):
        """
        返回key值在CLI回显中的顺序
        """
        if "Horizontal" == self.__cliRetType:
            return cliRetHorizontal.getKeyOrder(self)
        elif "Vertical" == self.__cliRetType:
            return cliRetVertical.getKeyOrder(self)

 
