# -*- coding:utf-8 -*-
import re
import os
import cmdManager
from contextUtil import getLogger,getDevIp
from contextUtil import getCheckModel

def getCliRetFromArray(context, cmd, flag):
    '''
    @summary: get CLI result from storage array
    @param context: the context object provided by tool framework
    @param cmd: the command which need to send
    @return: CLI result information
    '''
    if flag == True:
        cmdRet = cmdManager.execCmd(context, cmd)
    else:
        cmdRet = cmdManager.execCmdNoLog(context, cmd)
    return cmdRet


def getCliRetFromFile(context, cmd):
    '''
    @summary: get CLI result from local file which is generated by information collect tool
    @param context: the context object provided by tool framework
    @param cmd: the command which need to send
    @return: CLI result information
    '''
    logger = getLogger(context)
    filePath = os.path.abspath('clicmd.txt')
    fileContent = open(filePath).read()
    pattern = '(%s.*?:/>)' % cmd
    ret4Search = re.search(pattern, fileContent, re.DOTALL)
    if not ret4Search:
        logger.info('[cmdRetManager] failed to get command [%s] from file.' % cmd)
        return None
    return ret4Search.group(1)


def getCliRet(context, cmd, flag = True):
    '''
    @summary: get CLI result from local file which is generated by information collect tool
    @param context: the context object provided by tool framework
    @param cmd: the command which need to send
    @return: CLI result information
    '''

    if "LINK" == unicode(getCheckModel(context)):
        return getCliRetFromArray(context, cmd, flag)
    else:
        filePath=context.getPkgPath
        ip=getDevIp(context)
        fileHandle=filePath+ip
        return getCliRetFromFile(context, cmd , fileHandle)


def checkCliInfoValid(cliInfo, necessaryFlag=False):
    '''
    @summary: check whether the CLI information is valid or not
    @param cliInfo: CLI information
    @return: boolean, CLI information is valid or not
    '''
    lineList = cliInfo.splitlines()
    if len(lineList) >= 7:
        return True
    #����Ҫ�е�����
    if necessaryFlag:
        return False
    
    flag = False
    if re.search("command operates successfully", cliInfo, re.IGNORECASE):
        flag = True
    elif re.search("license", cliInfo, re.IGNORECASE):
        flag = True
    elif re.search("not exist", cliInfo, re.IGNORECASE):
        flag = True
    elif re.search("not support", cliInfo, re.IGNORECASE):
        flag = True
    else:
        flag = False
    
    return flag
