﻿# -*- coding: UTF-8 -*-
import os
from common.constant import CheckedResult
from common.sysInfoManager import switchDeviceType,isAfterSecure,switchValidVersion
from common.contextUtil import getPdtVer,getDestVer,getDevType,getUpgradeModel,getLogger
import defusedxml.ElementTree as ET

def execute(context):
    '''
    @summary      : the entrance of main method, filter item accronding to the rules
    @param context: context
    @return       : flag, cliRet, errMsg
    '''
    flag = CheckedResult.PASS
    cliRet = ''
    errMsg = ''
    
    logger = getLogger(context)
    #源版本
    curVer=switchValidVersion(getPdtVer(context))
    #目标版本
    destVer=getDestVer(context)
    #设备型号
    devModel=getDevType(context)
    #升级模式
    upgradeMode=getUpgradeModel(context)
    
    SUB_FILE_PATH = r'packages\UpgradeEvaluation\products\S5000TV100\innerVerion\checklist_innerversion_base.xml'
    filePath = os.getcwd() + os.sep + SUB_FILE_PATH.replace('\\', os.sep)
    filterList = ET.parse(filePath)

    #根据安全红线过滤
    isSecure=isAfterSecure(curVer)
    filterList = filterSecureLine(filterList, isSecure)
    
    #根据升级模式过滤
    filterList = filterUpgradeManner(filterList,upgradeMode)
    
    #根据版本受限过滤
    filterList=filterVersionLimit(curVer,destVer,devModel,filterList)
    
    #删除无关属性
    filterList=filterItemName(filterList)
    
    #删除没有孩子节点“item”的“module”节点
    filterNoChildModule(context, filterList)
    #node类型转化为str
    cliRet=getCheckList(filterList)
    logger.info('[checklist_filter]check list:' + unicode(cliRet))
    return (flag, cliRet, errMsg)

def getCheckList(node):
    '''
    @Function name      : getCheckList
    @Function describe  : 将节点转化为字符串型checklist
    @Input              : node
    @Return             : checklist
    '''
    root=node.getroot() 
    checklist= ET.tostring(root,encoding="utf-8")
    checklist='''<?xml version="1.0" encoding="UTF-8"?>\n'''+checklist
    return checklist
            
def filterSecureLine(checklist, secure):
    '''
    @Function name      : filterSecureLine(checklist, secure)
    @Function describe  : 根据安全红线过滤checklist
    @Input              : checklist, secure
    @Return             : checklist
    '''
    
    for node in checklist.getiterator("module"):
        items=node.getchildren()
        iFlag=0
        lenItem=len(items)
        while iFlag<lenItem:
            if items[iFlag].attrib.has_key("aftersecure"):
                if items[iFlag].attrib["aftersecure"].lower() != unicode(secure).lower():
                    node.remove(items[iFlag])
                    iFlag-=1
                    lenItem-=1
            iFlag+=1 
    return checklist

def filterUpgradeManner(checklist, method):
    '''
    @Function name      : filterUpgradeManner(checklist)
    @Function describe  : 根据升级方式过滤checklist
    @Input              : checklist, method
    @Return             : checklist
    '''
    for node in checklist.getiterator("module"):
        items=node.getchildren()
        iFlag=0
        lenItem=len(node.getchildren())
        while iFlag<lenItem:
            if items[iFlag].attrib.has_key("upgrademode") and items[iFlag].attrib["upgrademode"].lower()!='all':
                if items[iFlag].attrib["upgrademode"].lower() != method.lower():
                    node.remove(items[iFlag])
                    iFlag-=1
                    lenItem-=1
                iFlag+=1     
            #未配置upgrademode和upgrademode=ALL的情况，默认都为upgrademode=ALL
            else:
                iFlag+=1
    return checklist

def filterVersionLimit(curVer,destVer,devType, checklist):
    '''
    @Function name      : filterVersionLimit(checklist)
    @Function describe  : 根据版本受限过滤checklist
    @Input              : checklist
    @Return             : checklist
    '''
    #根据源版本、目标版本、设备类型获取受限的检查项
    verUpgLimitLst = getVerUpgLimitLst(curVer,destVer,devType)
    for node in checklist.getiterator("module"):
        items=node.getchildren()
        iFlag=0
        lenItem=len(node.getchildren())
        while iFlag<lenItem:
            if items[iFlag].attrib.has_key("upgralimit") > 0 and items[iFlag].attrib["upgralimit"] == "true" and items[iFlag].attrib["id"] not in verUpgLimitLst:
                node.remove(items[iFlag])
                iFlag-=1
                lenItem-=1
            iFlag+=1     
                                 
    return checklist

def getVerUpgLimitLst(curVer,destVer,devType):
    '''
    @Function name      : getVerUpgLimitLst(checklist)
    @Function describe  : 根据源版本、目标版本、设备类型获取受限的检查项
    @Input              : curVer,destVer,devType
    @Return             : verUpgLimitLst
    '''
    limitDeviceType = ""
    limitCurVerCon = ""
    limitCurVerLogic = ""
    limitDstVerCon = ""
    limitDstVerLogic = ""
    deviceType=switchDeviceType(devType)
    ProductVersion = curVer[0:11]
    verUpgLimitLst = []
    cfgFilePath = r'packages\UpgradeEvaluation\products\S5000TV100\innerVerion\check_item_limit.xml'
    root = ET.parse(os.getcwd() + os.sep + cfgFilePath.replace('\\', os.sep))
    for type_node in root.getiterator("Type"):
        if type_node.attrib['ProductVersion'] == ProductVersion:
            for upg_node in type_node.getchildren():
                checkItemID = upg_node.attrib["CheckItemID"]
                for node in upg_node.getchildren():
                    if node.tag == "CurVer":
                        limitCurVerLogic = node.attrib["Logic"]
                        limitCurVerCon = node.text
                    if node.tag == "DstVer":
                        limitDstVerLogic = node.attrib["Logic"]
                        limitDstVerCon = node.text
                    if node.tag == "DeviceType":
                        limitDeviceType = node.text
                #查询产品型号是否满足
                if limitDeviceType != "ALL" and limitDeviceType != deviceType:
                    continue
                #查询源版本是否满足
                if not isVerInRange(limitCurVerLogic,curVer,limitCurVerCon):
                    continue
                #查询目标版本是否满足
                if not isVerInRange(limitDstVerLogic,destVer,limitDstVerCon):
                    continue
                verUpgLimitLst.append(checkItemID)
    return verUpgLimitLst

def isVerInRange(limitVerLogic,ver,limitVerCon):
    '''
    @Function name      : isVerInRange
    @Function describe  : 判断版本是都在范围内
    @Input              : limitVerLogic,ver,limitVerCon
    @Return             : True/False
    '''
    #如果Logic为ALL，则认为所有版本均满足
    if limitVerLogic == "ALL":
        return True
    elif ver[0:11] == limitVerCon[0:11]:
        if limitVerLogic == "Equal" and ver == limitVerCon:
            return True
        elif limitVerLogic == "Great" and ver > limitVerCon:
            return True
        elif limitVerLogic == "Less" and ver < limitVerCon:
            return True
        elif limitVerLogic == "GreatEqual" and ver >= limitVerCon:
            return True
        elif limitVerLogic == "LessEqual" and ver <= limitVerCon:
            return True
        elif limitVerLogic == "Range":
            field = limitVerCon.split(",")
            if len(field) == 2:
                RangeVerMin = field[0]
                RangeVerMax = field[1]
                if ver >= RangeVerMin and ver <= RangeVerMax:
                    return True
        else:
            return False
    else:
        return False
    
def filterItemName(checklist):
    '''
    @Function name      : filterItemName(checklist)
    @Function describe  : 输出无关属性
    @Input              : checklist
    @Return             : checklist
    '''
    for node in checklist.getiterator("module"):
        if node is not None:
            del node.attrib["name"]
            for item in node.getchildren():
                del item.attrib["name"]
                if item.attrib.has_key("aftersecure"):
                    del item.attrib["aftersecure"]
                if item.attrib.has_key("upgralimit"):
                    del item.attrib["upgralimit"]
                if item.attrib.has_key("upgrademode"):#兼容upgrademode未配置的情况
                    del item.attrib["upgrademode"]
    return checklist


def filterNoChildModule(context, checklist):
    '''
    @summary: filter the node named 'module' which has no child node
    @param context: the dictionary of data which provided by tool framework
    @param checklist: an object which stand for the XML configuration file is parsed as a tree
    '''
    rootNode = checklist.getroot()
    for nodeModule in rootNode.getchildren():
        curNodeItemList = nodeModule.getchildren()
        #删除空节点
        if not curNodeItemList:
            rootNode.remove(nodeModule)
