# -*- coding: UTF-8 -*-

import re 
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check BBU power
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    ControllerID = ''
    BBUID = ""
    errMsg = ""
    
    cliRet = getCliRet(dataDict, "showbbu")       
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."
        return (flag, cliRet, errMsg)   
       
    for field in list:
        field = field.replace(" ", "").replace("|", "")
        
        if field.startswith("BBUID"):
            BBUID = field.replace("BBUID", "")
        elif field.startswith('ControllerID'):
            ControllerID = field.replace('ControllerID', '')
        elif field.startswith("BBUPower"):
            if field.replace("BBUPower", "") != "Sufficient":
                flag = CheckedResult.NOTPASS
                #若控制器ID存在，则加入控制器ID
                if ControllerID:
                    if "zh" == lang:
                        errMsg += u'\n控制器%s的BBU%s电量不足。' % (ControllerID, BBUID)
                    else:
                        errMsg += '\nThe BBU %s of controller %s has insufficient power.' % (BBUID, ControllerID)
                else:
                    if "zh" == lang:
                        errMsg += u'\nBBU%s的电量不足。' % BBUID
                    else:
                        errMsg += '\nThe power of BBU %s is insufficient.' % BBUID
    
    return (flag, cliRet, errMsg)