# -*- coding: UTF-8 -*-

import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger, getUpgradeModel



"""查询LUN的Cache写策略"""
def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check cache write strategy
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    """"cli命令回显信息
    showlun
    =========================================================================================================================================
                                                LUN Information
    -----------------------------------------------------------------------------------------------------------------------------------------
      ID    RAID Group ID    Disk Pool ID    Status    Controller    Visible Capacity(MB)    LUN Name      Stripe Unit Size(KB)    Lun Type  
    -----------------------------------------------------------------------------------------------------------------------------------------
      0     0                --              Normal    A             57344.0                 LUN001        64                      FAT       
      1     0                --              Normal    B             57344.0                 LUN002        64                      FAT       
      2     1                --              Normal    A             96256.0                 LUN003_001    64                      FAT       
    =========================================================================================================================================
    
    admin:/>"""

    tempwritestrategy = ""
    temprunwritestrategy = ""
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    cliRet = ""
    errCounter = 0
    
    #获取升级模式：Online、Offline
    UpgModel = getUpgradeModel(dataDict)

    cliRet = getCliRet(dataDict, "showlun", False)
    list = cliRet.splitlines()
    
    """判断cli回显信息是否满足要求"""
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."
        return (flag, cliRet, errMsg)
    
    for field in list[6:]:
        
        luninfo = field.split()
        if len(luninfo) < 7:
            continue
        else:
            lunId = luninfo[0]
            #查询指定LUN的Cache写策略状态
            iRet = checkCacheWriteStrategy(dataDict, lunId, UpgModel)
            if CheckedResult.NOTPASS == iRet[0] and errCounter < 10:
                cliRet += '\n\n' + iRet[1]
                errCounter += 1
            tempwritestrategy = iRet[2]
            temprunwritestrategy = iRet[3]
    
            if CheckedResult.NOTPASS == iRet[0]:
    
                flag = CheckedResult.NOTPASS
                if "zh" == lang:
                    errMsg += u"\nLUN[ID:%s]" % lunId+ u"的Cache写策略异常，配置的Cache写策略为" + unicode(tempwritestrategy)\
                                + u"，当前运行的Cache写策略为" + unicode(temprunwritestrategy) + u"。"
                else:
                    errMsg += "\nThe cache write strategy of LUN[ID:%s]" % lunId +" is not normal, Cache Write Strategy is "\
                                + unicode(tempwritestrategy) + u", Running Cache Write Strategy is " + unicode(temprunwritestrategy) + u"."

    return (flag, cliRet, errMsg)

def checkCacheWriteStrategy(dataDict, lunId, UpgModel):
    
    """cli命令回显信息
    【V1R1】(有效内容行数26)
    admin:/>showlun -lun 24
    ===================================================================
                              LUN Information                          
    -------------------------------------------------------------------
      ID                           | 24
      Name                         | LUN001_24
      LUN WWN                      | 6784905100a12200005eb22500000018
      Status                       | Normal
      Capacity(MB)                 | 2048.0
      Stripe Unit Size(KB)         | 64
      RAID Group ID                | 1
      Format Progress(%)           | --
      Owning Controller            | B
      Working Controller           | B
      Cache Prefetch Strategy      | Intelligent
      Cache Write Strategy         | Write back; Mirroring
      Running Cache Write Strategy | Write back; Mirroring
      Change stripped size         | --
      Stripe Unit Size Progress(%) | --
      Stripe Unit Size Speed       | --
      Extending LUN                | --
      Pool ID                      | --
      SnapShot ID                  | --
      LunCopy ID                   | 0
      Whether Private LUN          | No
      Remote Replication ID        | --
    ===================================================================
    
    admin:/>
    【V1R2】(有效内容行数30)
    admin:/>showlun -lun 0    
    ===================================================================
                              LUN Information
    -------------------------------------------------------------------
      ID                           | 0
      Name                         | LUN001
      LUN WWN                      | 630397510068393001869d9b00000000
      Status                       | Normal
      Visible Capacity(MB)         | 57344.0
      Stripe Unit Size(KB)         | 64
      RAID Group ID                | 0
      Format Progress(%)           | --
      Owning Controller            | A
      Working Controller           | A
      Cache Prefetch Strategy      | Intelligent
      Cache Write Strategy         | Write back; Mirroring
      Running Cache Write Strategy | Write back; Mirroring
      Change stripped size         | --
      Stripe Unit Size Progress(%) | --
      Stripe Unit Size Speed       | --
      Extending LUN                | --
      Lun Type                     | FAT
      Consumed Capacity(MB)        | --
      Reclaim Progress(%)          | --
      Pool ID                      | --
      SnapShot ID                  | 6
      LunCopy ID                   | 0
      Whether Private LUN          | No
      Remote Replication ID        | 3039756839300000
      Split mirror ID              | --
    ===================================================================
        
    admin:/>"""
    
    #信息初始化
    tempwritestrategy = ""
    temprunwritestrategy = ""
    flag = CheckedResult.PASS
    
    cliRet = getCliRet(dataDict, "showlun -lun " + unicode(lunId))
    list = cliRet.splitlines()
    
    """判断cli回显信息是否满足要求"""
    count = len(list)
    for index in range(count):
        if re.search('Whether Private LUN', list[index], re.IGNORECASE):
            if re.search('Yes', list[index], re.IGNORECASE):
                return (CheckedResult.PASS, cliRet, '', '')
            else:
                break
        else:
            continue

    if count < 20:
        return(CheckedResult.NOTPASS, cliRet, '', '')

    """查询lun的cache写策略"""
    for field in list:
        #取得运行的cache写策略
        if bool(re.search('Running Cache Write Strategy', field, re.IGNORECASE)):
            #取得运行的cache写策略
            temprunwritestrategy = field.replace('Running Cache Write Strategy |', '').lstrip()
            continue
        
        #查询配置的cache写策略
        if bool(re.search('Cache Write Strategy', field, re.IGNORECASE)):
            #取得配置的cache写策略
            tempwritestrategy = field.replace('Cache Write Strategy', '').replace('|', '').lstrip()
            continue

    #配置策略与运行策略必须要相同
    if temprunwritestrategy != tempwritestrategy:
        flag = CheckedResult.NOTPASS
    return(flag, cliRet, tempwritestrategy, temprunwritestrategy)

 