# -*- coding: UTF-8 -*-

import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



"""云备份任务巡检"""
def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Cloudbackup Task
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    """
    admin:/>showcloudbackup
    ===============================================================================
                           Cloud Backup Information
    -------------------------------------------------------------------------------
      Cloud Backup ID    Cloud Backup Name    Running Status        Health Status  
    -------------------------------------------------------------------------------
      0                  CloudBackup001       Copying               Normal         
      1                  CloudBackup002       Copy Completed        Normal         
      2                  CloudBackup003       Recovery Completed    Normal         
      3                  CloudBackup004       Copying               Normal         
    ==============================================================================="""


    flag = CheckedResult.PASS
    cloudBackUpId = ""
    cloudBackUpName = ""
    healthStatus = ""
    lang = getLang(dataDict)
    errMsg = ""

    #P12V-2729 云备份任务检查优化 modified 20130708 Begin
    
    cliRet = getCliRet(dataDict, "showcloudbackup")

    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."          
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 4:
            continue
        
        #P12V-2729 云备份任务检查优化 modified 20130708 Begin
        cloudBackUpId = list2[0]
        cloudBackUpName = list2[1]

        healthStatus = list2[-1]
        if "Normal" != healthStatus:
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n云备份任务（ID：" + cloudBackUpId + u"，名称：" + cloudBackUpName + u"）的健康状态存在异常。"
            else:
                errMsg += u"\nThe health status of Cloudbackup task (ID:" + cloudBackUpId + u"，name:" + cloudBackUpName + u") is abnormal."
        else:
            temp = checkRunningStatus(dataDict, list2, lang)
            if temp[1] != "":
                cliRet += temp[1]
            if True == temp[0]:
                continue
            else:
                flag = CheckedResult.NOTPASS
                errMsg += temp[2]
        #P12V-2729 云备份任务检查优化 modified 20130708 End

    return (flag, cliRet, errMsg)

#P12V-2729 云备份任务检查优化 added 20130708 Begin
# **************************************************************************** #
# 函数名称: checkRunningStatus
# 功能说明: 检查当前云备份任务运行状态是否异常
# **************************************************************************** # 
def checkRunningStatus(dataDict, list, lang):
    checkFlag = False
    errMsg = ""
    cliRet = ""
    
    cloudBackUpId = list[0]
    cloudBackUpName = list[1]

    temp = list[-2]
    if temp == "Stopped":
        checkFlag = True
    elif temp in ["Copying", "Recovering"]:
        checkFlag = False
    elif temp == "Completed":
        #查询云备份是否设定为手动触发
        checkCmd = "showcloudbackup -cloudbackup " + cloudBackUpId
        cliRet = getCliRet(dataDict, checkCmd)
        lineList = cliRet.splitlines()
        if len(lineList) < 7:
            checkFlag = False
        else:
            for line in lineList:
                if re.search("Synchronous Type", line, re.IGNORECASE):
                    if re.search("Manual", line, re.IGNORECASE):
                        checkFlag = True
                    else:
                        checkFlag = False
                    break
                else:
                    continue
    else:
        checkFlag = False
    
    #设定返回值
    if False == checkFlag:
        if "zh" == lang:
            errMsg += u"\n云备份任务（ID：" + cloudBackUpId + u"，名称：" + cloudBackUpName + u"）的运行状态存在异常。"
        else:
            errMsg += u"\nThe running status of Cloudbackup task (ID:" + cloudBackUpId + u"，name:" + cloudBackUpName + u") is abnormal."
    
    return (checkFlag, cliRet, errMsg)
