# -*- coding: UTF-8 -*-

import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger


def execute(dataDict):
    '''
    @summary: the entrance of main method
    @detail: this check item is used to check controller status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    controllerID = ""
    operationStatus = ""
    healthStatus = ""
 
    cliRet = getCliRet(dataDict, "showcontroller")
    if not re.search("Controller Information", cliRet, re.IGNORECASE):
        return (CheckedResult.NOTPASS, cliRet, "Get Controller Information Error!")
    list = cliRet.splitlines()
    for field in list:
        field = field.replace(" ", "").replace("|", "")
        if field.startswith("ControllerID"):
            controllerID = field.replace("ControllerID", "")
        elif field.startswith("OperationStatus"):
            operationStatus = field.replace("OperationStatus", "")
            if "Normal" != operationStatus:
                flag = CheckedResult.NOTPASS
                if "zh" == lang:
                    errMsg += u"\n控制器" + controllerID + u"的操作状态存在异常（" + operationStatus + u"）。"
                else:
                    errMsg += "\nThe operation status of controller " + controllerID\
                              + " is abnormal(" + operationStatus + ")."
        elif field.startswith("HealthStatus"):
            healthStatus = field.replace("HealthStatus", "")
            if "Normal" != healthStatus:
                flag = CheckedResult.NOTPASS
                if "zh" == lang:
                    errMsg += u"\n控制器" + controllerID + u"的健康状态存在异常（" + healthStatus + u"）。"
                else:
                    errMsg += "\nThe health status of controller " + controllerID\
                              + " is abnormal(" + healthStatus + ")."
    return (flag, cliRet, errMsg)