# -*- coding: UTF-8 -*-

import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



"""脏数据检查"""
def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check dirty data
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    """
    showcache 
    =============================================
                  Cache Information
    ---------------------------------------------
      Controller ID                      | A
      Total Memory Capacity(MB)          | 4096
      System Memory Capacity(MB)         | 2039
      Cache Capacity(MB)                 | 2057
      Cache Utilization                  | 0
      Cache Hit Ratio(%)                 | 0
      Current Cache Water Level(%)       | 0
      High Water Level(%)                | 80
      Low Water Level(%)                 | 40
      Read Cache Capacity(MB)            | 274
      Write Cache Capacity(MB)           | 274
      Mirroring Write Cache Capacity(MB) | 274
      Read Cache Utility(%)              | 0
      Write Cache Utility(%)             | 0
      Mirroring Write Cache Utility(%)   | 0
      Whether dirty data exists          | No
    ---------------------------------------------
      Controller ID                      | B
      Total Memory Capacity(MB)          | 4096
      System Memory Capacity(MB)         | 2039
      Cache Capacity(MB)                 | 2057
      Cache Utilization                  | 0
      Cache Hit Ratio(%)                 | 0
      Current Cache Water Level(%)       | 0
      High Water Level(%)                | 80
      Low Water Level(%)                 | 40
      Read Cache Capacity(MB)            | 274
      Write Cache Capacity(MB)           | 274
      Mirroring Write Cache Capacity(MB) | 274
      Read Cache Utility(%)              | 0
      Write Cache Utility(%)             | 0
      Mirroring Write Cache Utility(%)   | 0
      Whether dirty data exists          | No
    =============================================
    
    admin:/>
    """
    flag = CheckedResult.PASS
    controllerId = ""
    lang = getLang(dataDict)
    errMsg = ""
    
    cliRet = getCliRet(dataDict, "showcache")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."    
        return (flag, cliRet, errMsg)

    for line in list[4:]:
        field = line.split()
        if re.search("Controller ID ", line, re.IGNORECASE):
            controllerId = field[3]
        elif re.search("Whether dirty data exists ", line, re.IGNORECASE):
            if re.search("Yes", line, re.IGNORECASE):
                flag = CheckedResult.NOTPASS
                if "zh" == lang:
                    errMsg += u"\n控制器" + controllerId + u"存在脏数据。"
                else:
                    errMsg += "\nThe controller " + controllerId + " exists the dirty data."
    return (flag, cliRet, errMsg)

