# -*- coding: UTF-8 -*-
import re 
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check disk physical status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    
    cliRet = getCliRet(dataDict, "showdisk -physic", False)
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
           flag = CheckedResult.NOTPASS
           if lang == "zh":
               errMsg = u"\nCli信息无效。"
           else:
               errMsg = "\nCli information invalid."         
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 2:
            continue
        if "Normal" != list2[1]:
            flag = CheckedResult.NOTPASS
            #取得硬盘物理状态
            physicStatus = ""
            if "Single" == list2[1]:
                physicStatus = "Single path"
            elif "Write" == list2[1]:
                physicStatus = "Write protect"
            elif "Off" == list2[1]:
                physicStatus = "Off line"
            else:
                physicStatus = list2[1]
                
            if "zh" == lang:
                errMsg += u"\n硬盘" + list2[0] + u"的物理状态存在异常（" + physicStatus + u"）。"
            else:
                errMsg += "\nThe physical status of disk " + list2[0] \
                          + " is abnormal(" + physicStatus + ")."

    return (flag, cliRet, errMsg)