# -*- coding: UTF-8 -*-
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger, getDestVer
from common.cTV1R1 import cHandleCliRet

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check LUN Status (Online)
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    log = getLogger(dataDict)
    devDest = getDestVer(dataDict)
    log.info("The destination version is:" + unicode(devDest))
    errMsg = ""
    cliRet = ""
    
    if devDest >= "V100R005C30SPC700":
        return (flag, cliRet, errMsg)
    
    cliRet += getCliRet(dataDict, "showenclosure", True)
    #判断cli信息是否有效
    if not checkCliInfoValid(cliRet):
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\nCli信息无效。"
        else:
            errMsg = "\nCli information invalid."           
        return (flag, cliRet, errMsg)
    
    #使用通用接口解析命令回文
    formatFunction = cHandleCliRet(cliRet)
    enclosureInfoList = formatFunction.handle()
    diskEnCount = 0
    for item in enclosureInfoList:
        if "Common" != item.get("Physical Type"):
            diskEnCount += 1
    log.info("All disk enclosure number is:" + unicode(diskEnCount))
    
    if diskEnCount > 7:
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg += u"\n硬盘框数量超过7个，请参考修复建议进行处理。"
        else:
            errMsg += "\nThe number of disk enclosures exceeds 7. Please perform operations as instructed in Recommended Suggestions."
    return (flag, cliRet, errMsg)
