# -*- coding: UTF-8 -*-

import re 
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



"""showenclosure
=========================================================================================================================
                                                  Enclosure Infomation
-------------------------------------------------------------------------------------------------------------------------
  Enclosure ID    Type          Status    Temperature(Celsius)    Physical Type    Serial Number           MAC Address   
-------------------------------------------------------------------------------------------------------------------------
  0               Controller    Online    32                      Common           210235G6EBZ0C1000007    303975683930  
  1               Expansion     Online    29                      FC               210235G6FPZ0B2000002    0022a104870e  
=========================================================================================================================

admin:/>
"""
def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check enclosure status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    
    
    cliRet = getCliRet(dataDict, "showenclosure")
    list = cliRet.splitlines()
    if len(list) < 9:
         #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
           flag = CheckedResult.NOTPASS
           if lang == "zh":
               errMsg = u"\nCli信息无效。"
           else:
               errMsg = "\nCli information invalid."           
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 7:
            continue
        if "Online" != list2[2]:
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n框" + list2[0] + u"的状态存在异常（" + list2[2] + u"）。"
            else:
                errMsg += "\nThe status of enclosure " + list2[0] \
                          + " is abnormal(" + list2[2] + ")."

    return (flag, cliRet, errMsg)

