# -*- coding: UTF-8 -*-
import re 
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check expansion module status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    controllerID = ""
    status = ""
    errMsg = ""
    
    cliRet = getCliRet(dataDict, "showexpmodule")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."
        return (flag, cliRet, errMsg)    
    
    for field in list:
        field = field.replace(" ", "").replace("|", "")
        if field.startswith("ControllerID"):
            controllerID = field.replace("ControllerID", "")
        elif field.startswith("EnclosureID"):
            enclosureID = field.replace("EnclosureID", "")
        elif field.startswith("Status"):
            status = field.replace("Status", "")
            if status != "Normal":
                flag = CheckedResult.NOTPASS
                if "zh" == lang:
                    tuple2BReplaced = (enclosureID, controllerID, status)
                    errMsg += u"\n框（ID：%s）的级联模块（ID：%s）状态异常（%s）。" % tuple2BReplaced
                else:
                    tuple2BReplaced = (controllerID, enclosureID, status)
                    errMsg += "\nThe status of the expansion module (ID:%s) in the enclosure (ID:%s) is abnormal(%s)." % tuple2BReplaced
  
    return (flag, cliRet, errMsg)