# -*- coding: UTF-8 -*-
import re 
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check fan status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    enclosureList = []
    fanList = ['0', '1', '2', '3']
    fanStatus = ""
    errMsg = ""
    
    cliRet = getCliRet(dataDict, "showenclosure")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
           flag = CheckedResult.NOTPASS
           if lang == "zh":
               errMsg = u"\nCli信息无效。"
           else:
               errMsg = "\nCli information invalid."        
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 7:
            continue
        enclosureList.append(list2[0])

    for enclosureID in enclosureList:
        for fanID in fanList:
            cliRet2 = getCliRet(dataDict, "showfan -e " + enclosureID + " -f " + fanID)
            list3 = cliRet2.splitlines()
            for field2 in list3:
                field2 = field2.replace(" ", "").replace("|", "")
                if field2.startswith("Status"):
                    cliRet += cliRet2
                    fanStatus = field2.replace("Status", "")
                    if fanStatus != "Normal":
                        flag = CheckedResult.NOTPASS
                        if "zh" == lang:
                            errMsg += u"\n框" + enclosureID + u"的风扇" + fanID\
                                      + u"的状态存在异常（" + fanStatus + u"）。"
                        else:
                            errMsg += "\nThe status of fan " + fanID + " of enclosure " \
                              + enclosureID + " is abnormal(" + fanStatus + ")."

    return (flag, cliRet, errMsg)
