# -*- coding: UTF-8 -*-
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.constant import CheckedResult
from common.contextUtil import getCurSysVer, getLang
from common.sysInfoManager import getCurHotPatchVersion


def execute(context):
    '''
    @summary: the entrance of main method, this check item is used to check Hot Patch
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    flag = CheckedResult.PASS
    cliRet = ""
    errMsg = ""
    currentVer = getCurSysVer(context)
    lang = getLang(context)
    #将限制提前拦截
    if currentVer not in ["V100R002C00SPC011", "V100R002C00SPC012"]:
        return (flag, cliRet, errMsg)
    
    #获取当前已安装热补丁版本
    iRet = getCurHotPatchVersion(context)
    processFlag = iRet[0]
    curHotPatchVer = iRet[1]
    cliRet = iRet[2]
    if not processFlag:
        flag = CheckedResult.NOTPASS
        if lang == "zh":
            errMsg = u"未获取有效的热补丁版本信息。"
        else:
            errMsg = "Failed to get hotpatch information."
        return (flag, cliRet, errMsg)
    if not curHotPatchVer:
        flag = CheckedResult.NOTPASS
        hotPatchName = ''
        if currentVer == "V100R002C00SPC011":
            hotPatchName = 'V100R002C00SPHb02'
        elif currentVer == "V100R002C00SPC012":
            hotPatchName = 'V100R002C00SPHc02'
        if lang == "zh":
            errMsg = u"未安装热补丁，请安装%s或以上版本热补丁。" % hotPatchName
        else:
            errMsg = "Hot patch is not installed, please install %s or a later version hot patch." % hotPatchName
        return (flag, cliRet, errMsg)
    #获取补丁后6位：SPHb01
    pureHotPatch = curHotPatchVer[curHotPatchVer.index("SPH"):]
    if currentVer == "V100R002C00SPC011":
        if pureHotPatch < "SPHb02":
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"未安装V100R002C00SPHb02或以上版本热补丁。"
            else:
                errMsg = "V100R002C00SPHb02 or a later version hot patch is not installed."
    elif currentVer == "V100R002C00SPC012":
        if pureHotPatch < "SPHc02":
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"未安装V100R002C00SPHc02或以上版本热补丁。"
            else:
                errMsg = "V100R002C00SPHc02 or a later version hot patch is not installed."

    return (flag, cliRet, errMsg)