# -*- coding: UTF-8 -*-

import re 
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check LUN Copy Status 
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    
    cliRet = getCliRet(dataDict, "showluncopy")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."            
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 5:
            continue
        
        #P12V-2725 modified 20130502 begin
        lunCpState = list2[3]
        lunCpStatus = list2[4]       
        
        if lunCpStatus == "Normal" \
        and lunCpState not in ["Copying", "Waiting"]:
            pass
        else:
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\nLUN拷贝" + list2[1] + u"的状态存在异常（"\
                          + u"运行状态：" + list2[3] + u"；健康状态：" + list2[4]\
                          + u"）。"
            else:
                errMsg += "\nThe LUN copy " + list2[1]\
                          + " is abnormal(" + "LUN Copy State:" + list2[3]\
                          +"; LUN Copy Status:" + list2[4] + ")."
        #P12V-2725 modified 20130502 end
        
    return (flag, cliRet, errMsg)