# -*- coding: UTF-8 -*-

import re
import string
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



"""查询LUN回写不镜像"""
def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check LUN writeback without mirroring
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    """"cli命令回显信息
    showlun
    =========================================================================================================================================
                                                LUN Information
    -----------------------------------------------------------------------------------------------------------------------------------------
      ID    RAID Group ID    Disk Pool ID    Status    Controller    Visible Capacity(MB)    LUN Name      Stripe Unit Size(KB)    Lun Type  
    -----------------------------------------------------------------------------------------------------------------------------------------
      0     0                --              Normal    A             57344.0                 LUN001        64                      FAT       
      1     0                --              Normal    B             57344.0                 LUN002        64                      FAT       
      2     1                --              Normal    A             96256.0                 LUN003_001    64                      FAT       
    =========================================================================================================================================
    
    admin:/>"""
    
    tempCacheWriteStrategy = ""
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    errCounter = 0
    
    cliRet = getCliRet(dataDict, "showlun", False)
    list = cliRet.splitlines()
    """判断cli回显信息是否满足要求"""
    if len(list) < 9:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."          
        return (flag, cliRet, errMsg)
    
    for field in list[6:]:
        
        luninfo = field.split()
        if len(luninfo) < 7:
            continue
        else:
            lunId = luninfo[0]
            #查询每一个LUN的回写不镜像状态
            iRet = checkwritebacknomirror(dataDict, lunId)
            if CheckedResult.NOTPASS == iRet[0] and errCounter < 10:
                cliRet += '\n\n' + iRet[1]
                errCounter += 1
            tempCacheWriteStrategy = iRet[2]
            #设置错误显示信息
            if CheckedResult.NOTPASS == iRet[0]:
                flag = CheckedResult.NOTPASS
                if "zh" == lang:
                    errMsg += u"\nLUN[ID:%s]运行的Cache写策略异常，" % lunId + u"Cache写策略为" \
                                + unicode(tempCacheWriteStrategy) + u"。" 
                else:
                    errMsg += "\nThe running cache write strategy of LUN[ID:%s]" % lunId +" is not normal, running cache write strategy is "\
                                + unicode(tempCacheWriteStrategy) + u"."
    return (flag, cliRet, errMsg)
    

def checkwritebacknomirror(dataDict, lunId):
    
    """cli命令回显信息
    admin:/>showlun -lun 0    
    ===================================================================
                              LUN Information
    -------------------------------------------------------------------
      ID                           | 0
      Name                         | LUN001
      LUN WWN                      | 630397510068393001869d9b00000000
      Status                       | Normal
      Visible Capacity(MB)         | 57344.0
      Stripe Unit Size(KB)         | 64
      RAID Group ID                | 0
      Format Progress(%)           | --
      Owning Controller            | A
      Working Controller           | A
      Cache Prefetch Strategy      | Intelligent
      Cache Write Strategy         | Write back; Mirroring
      Running Cache Write Strategy | Write back; Mirroring
      Change stripped size         | --
      Stripe Unit Size Progress(%) | --
      Stripe Unit Size Speed       | --
      Extending LUN                | --
      Lun Type                     | FAT
      Consumed Capacity(MB)        | --
      Reclaim Progress(%)          | --
      Pool ID                      | --
      SnapShot ID                  | 6
      LunCopy ID                   | 0
      Whether Private LUN          | No
      Remote Replication ID        | 3039756839300000
      Split mirror ID              | --
    ===================================================================
        
    admin:/>"""
    #信息初始化
    RunCacheWriteStrategy = ''
    flag = CheckedResult.PASS
    
    cliRet = getCliRet(dataDict, "showlun -lun " + unicode(lunId))
    list = string.split(cliRet, '\n')
    
    """判断cli回显信息是否满足要求"""
    count = len(list)
    for index in range(count):
        if re.search('Whether Private LUN', list[index], re.IGNORECASE):
            if re.search('Yes', list[index], re.IGNORECASE):
                return (CheckedResult.PASS, cliRet, '', '')
            else:
                break
        else:
            continue

    if count < 20:
        return(CheckedResult.NOTPASS, cliRet, '', '')

    """查询lun的运行cache写策略"""
    for field in list:
        if bool(re.search('Running Cache Write Strategy', field, re.IGNORECASE)):
            #回写不镜像查询
            if bool(re.search('Write back; No mirroring', field, re.IGNORECASE)):
                RunCacheWriteStrategy = 'Write back; No mirroring'
                flag = CheckedResult.NOTPASS
            else:
                RunCacheWriteStrategy = field.replace('Running Cache Write Strategy | ', '')
                flag = CheckedResult.PASS
            break

    return(flag, cliRet, RunCacheWriteStrategy)

 