# -*- coding: UTF-8 -*-
import re 
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Link Status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    
    cliRet = getCliRet(dataDict, "showrmtlink")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."          
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 4:
            continue
        if list2[3] != "Connected":
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n阵列间链路" + list2[0] + u"的状态存在异常（" + list2[3] + u"）。"
            else:
                errMsg += "\nThe status of link " + list2[0]\
                          + " is abnormal(" + list2[3] + ")."

    return (flag, cliRet, errMsg)
"""P12V-2720 20130507 added end"""