# -*- coding: UTF-8 -*-
import re     
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger, getUpgradeModel


def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check memory capacity
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    flag = CheckedResult.PASS
    errMsg = ""
    UpgModel = getUpgradeModel(dataDict)
    lang = getLang(dataDict) 
   
    cliRet = getCliRet(dataDict, "showcache")
    list = cliRet.splitlines()
    if len(list) < 7:
        #小于7行，Cli信息无效
        flag = CheckedResult.NOTPASS
        if lang == "zh":
            errMsg = u"\nCli信息无效。"
        else:
            errMsg = "\nCli information invalid."          
        return (flag, cliRet, errMsg)
    
    #获取所有控制器内存大小
    memCapacityList = []
    for field in list:
        if re.search("Total Memory Capacity", field, re.IGNORECASE):
            list2 = field.split("|")
            if len(list2) == 2:
                memCapacity = list2[1].strip()
                memCapacityList.append(memCapacity)
    
    #获取内存信息失败
    if len(memCapacityList) == 0 or len(memCapacityList) > 2:
        flag = CheckedResult.NOTPASS
        if lang == "zh":
            errMsg = u"\n获取控制器内存信息失败。"
        else:
            errMsg = "\nGetting memory capacity data failed."          
        return (flag, cliRet, errMsg)
    #单控不能在线升级
    elif len(memCapacityList) == 1:
        if UpgModel == "ONLINE":
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\n当前设备为单控，不支持在线升级。"
            else:
                errMsg = "\nCurrent system is single controller, can not support online upgrade."          

        return (flag, cliRet, errMsg)
    #获取双控信息
    else:
        #两端内存不一致，不允许升级
        if memCapacityList[0] != memCapacityList[1]:
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\n两端控制器内存不一致，不能执行升级。"
            else:
                errMsg = "\nThe memory capacity of two controllers are not same, can not support upgrade."
            return (flag, cliRet, errMsg)

        #在线升级，不允许控制器内存为2GB
        if "2048" in memCapacityList and UpgModel == "ONLINE":
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\n控制器内存为2GB，不允许在线升级，请选择离线升级。"
            else:
                errMsg = "\nThe controller's memory capacity is 2GB, can not support online upgrade, please select the offline upgrade."
            return (flag, cliRet, errMsg)
    
    #检查通过返回
    return (flag, cliRet, errMsg)