# -*- coding: UTF-8 -*-

import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check power supply status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    powerStatus = ""
    errMsg = ""
    
    cliRet = getCliRet(dataDict, "showpower")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 4:
            continue
        # There are three kinds of status: Normal, No Input and Fault.
        # The status "No Input" is special(a space between the two words),
        # therefore it should be special treated. 
        """电源状态判断条件增加 added Begin"""
        if list2[2] in ["No", "Input", "Not", "I2C", "Voltage", "Switch"]:
            powerStatus = list2[2] + " " + list2[3]
        else:
            powerStatus = list2[2]
        """电源状态判断条件增加 added End"""
            
        if powerStatus != "Normal":
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n框" + list2[0] + u"的电源" + list2[1]\
                          + u"的状态不正常（" + powerStatus + u"）。"
            else:
                errMsg += "\nThe status of power " + list2[1] + " of enclosure " \
                          + list2[0] + " is abnormal(" + powerStatus + ")."

    return (flag, cliRet, errMsg)