# -*- coding: UTF-8 -*-
import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



# **************************************************************************** #
# 函数名称: checkExpandDiskStatus
# 功能说明: 查询所有Raid组的动态扩盘状态
# 输入参数: cliInfo
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def checkExpandDiskStatus(dataDict, lang, raidGroupIdList):

    flag = CheckedResult.PASS
    errMsg = ""
    cliRet = ""
        
    #查询Raid组的扩盘状态
    for raidGroupId in raidGroupIdList:
        
        execCmd = "showrg -rg " + raidGroupId
        cliRetTmp = getCliRet(dataDict, execCmd)
        cliRet += cliRetTmp + "\n"
        
        lineList = cliRetTmp.splitlines()
        if len(lineList) < 7:
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg += execCmd + u"命令执行失败。\n"
            else:
                errMsg += execCmd + " command operation failed.\n"
            #继续查询下一个Raid组
            continue
        
        for line in lineList:
            if re.search("Dynamic Operation", line, re.IGNORECASE):
                if re.search("Expand Disk", line, re.IGNORECASE):
                    flag = CheckedResult.NOTPASS
                    if lang == "zh":
                        errMsg += u"Raid组" + raidGroupId + u"正在执行动态扩盘。\n"
                    else:
                        errMsg += "Raid Group " + raidGroupId + " is expanding disk.\n"
                break
             
    return (flag, cliRet, errMsg)


def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Dynamic RAID Group Expansion
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    flag = CheckedResult.PASS
    errMsg = ""
    raidGroupIdList = []
    lang = getLang(dataDict) 
   
    cliRet = getCliRet(dataDict, "showrg")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."       
        return (flag, cliRet, errMsg)

    #构造Raid组ID列表
    for line in list[6:]:
        field = line.split()
        if len(field) < 4:
            continue
        raidGroupIdList.append(field[0])
    #获取Raid组信息为空，返回错误
    if len(raidGroupIdList) == 0:
        flag = CheckedResult.NOTPASS
        if lang == "zh":
            errMsg = u"\nCli信息无效。"
        else:
            errMsg = "\nCli information invalid."
        return (flag, cliRet, errMsg)
        
    #查询Raid组的扩盘状态
    iRet = checkExpandDiskStatus(dataDict, lang, raidGroupIdList)
    flag = iRet[0]
    cliRet += "\n" + iRet[1]
    errMsg = iRet[2]

    return (flag, cliRet, errMsg)
