# -*- coding: UTF-8 -*-
import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger


def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check RAID group spindown status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    """showrgprdspindown
    ======================================================================================================================================
                                                           Time Information
    --------------------------------------------------------------------------------------------------------------------------------------
      RAID Group ID    Spindown Status    Valid Days    Start Time1    End Time1    Start Time2    End Time2    Start Time3    End Time3  
    --------------------------------------------------------------------------------------------------------------------------------------
      2                Not Spindown       Every Day     15:46:00       22:34:00     00:00:00       00:00:00     00:00:00       00:00:00   
      3                Spindown           Every Day     11:00:00       19:30:00     00:00:00       00:00:00     00:00:00       00:00:00   
    ======================================================================================================================================

    admin:/>"""

    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    
    cliRet = getCliRet(dataDict, "showrgprdspindown")
    cliRet += "\n" + getCliRet(dataDict, "showrgiospindown")
    
    if re.search("Spindown Status", cliRet, re.IGNORECASE):
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg += u"系统设置了Raid组休眠，会导致升级失败。"
        else:
            errMsg += "The storage system contains raid group which is set to spin_down, which can result in upgrade failure."

    return (flag, cliRet, errMsg)

