# -*- coding: UTF-8 -*-

import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Resource Pool
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    usage = 0
    threadshold = 0
    
    cliRet = getCliRet(dataDict, "showrespool")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid." 
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 3:
            continue
        if float(list2[1]) > 0.0:
            usage = int(float(list2[2]) / float(list2[1]) * 100)
            threadshold = int(list2[4])
            if usage >= threadshold:
                flag = CheckedResult.NOTPASS
                if "zh" == lang:
                    errMsg += u"\n资源池" + list2[0] + u"的使用率是" + unicode(usage)\
                              + u"%，达到或超过临界值" + unicode(threadshold) + u"%。"
                else:
                    errMsg += "\nThe usage(" + unicode(usage) + "%) of the resource pool " + list2[0]\
                              + " reaches or exceeds the threshold(" + unicode(threadshold) + "%)."

    return (flag, cliRet, errMsg)
