# -*- coding: UTF-8 -*-
import re 
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Split mirror Status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    mirrorlist = []
    
    cliRet = getCliRet(dataDict, "showmirror")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."           
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 2:
            continue
        mirrorlist.append(list2[1])

    #P11G-5870 分裂镜像检查项优化 modified 20130713 Begin
    for mirrorid in mirrorlist:
        cliRet2 = getCliRet(dataDict, "showsecluninmirror -mirror " + mirrorid)
        cliRet += cliRet2
        list3 = cliRet2.splitlines()
        if len(list3) < 7:
            if not checkCliInfoValid(cliRet2):
                flag = CheckedResult.NOTPASS
                if lang == "zh":
                    errMsg += u"\nCli信息无效(分裂镜像ID：" + mirrorid + u")。"
                else:
                    errMsg += "\nCli information invalid (Mirror ID: " + mirrorid + ")." 
            continue

        for field2 in list3[6:]:
            list4 = field2.split()
            if len(list4) < 4:
                continue
            if list4[3] != "Split":
                flag = CheckedResult.NOTPASS
                if "zh" == lang:
                    errMsg += u"\n分裂镜像" + mirrorid + u"的pair" + list4[2] + u"未分裂完成。"
                else:
                    errMsg += "\nThe Pair " + list4[2] + " of mirror "\
                              + mirrorid + " has not been split."
    #P11G-5870 分裂镜像检查项优化 modified 20130713 End
                              
    return (flag, cliRet, errMsg)