# -*- coding: UTF-8 -*-

import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



"""Thin业务检查"""
def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Thin Check
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    """
    showpool
    ===============================================================================
                                   Pool Information
    -------------------------------------------------------------------------------
      ID    Name           Level    Status    Available Capacity(MB)    Disk list  
    -------------------------------------------------------------------------------
      0     ThinPool001    RAID0    Fault     402432.0                  0,2;       
      1     ThinPool002    RAID1    Normal    930816.0                  0,5;0,6;   
    ===============================================================================
    
    admin:/>
    """
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""

    

    cliRet = getCliRet(dataDict, "showpool", False)
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."         
        return (flag, cliRet, errMsg)
    else:
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg += u"\n设备配置了Thin Pool，不能进行在线升级。"
        else:
            errMsg += "\nThe device configures the Thin pool."
    return (flag, cliRet, errMsg)

#P11A-7849 在线升级新增Thin业务检查 added 20130624 End
